package com.yifu.cloud.plus.v1.ekp.service.impl.QwExce;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.config.WxConfig;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankAtta;
import com.yifu.cloud.plus.v1.ekp.entity.EkpInvoiceInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpBankAttaMapper;
import com.yifu.cloud.plus.v1.ekp.mapper.QwExcelApiMapper;
import com.yifu.cloud.plus.v1.ekp.service.QwExcelApiService;
import com.yifu.cloud.plus.v1.ekp.util.SmartSheetDebugService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.MonthCalculationUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2025/9/26
 * @Description
 * @Version 1.0
 */
@Log4j2
@Service
public class QwExcelApiServiceImpl extends ServiceImpl<QwExcelApiMapper, EkpInvoiceInfo> implements QwExcelApiService {
	@Autowired
	private SmartSheetDebugService debugService;
	@Autowired
	private WxConfig wxConfig;
	@Override
	public void wxExcelApi() {
		int batchSize = 1000;
		int batchCount = 0;
		log.info("微信智能表格发票数据插入开始...");
		//获取最近24个月的发票信息，按月去插入到智能表格中
		String[] monthRange =null;
		List<Map<String, Object>> records = new ArrayList<>();
		List<Map<String, Object>> tempRecords = null;
		for (int i = 0; i < 24; i++){
			monthRange  =MonthCalculationUtils.calculateMonthRange(i);
			if (null != monthRange && monthRange.length == CommonConstants.dingleDigitIntArray[2]){
				tempRecords =  baseMapper.selectInvoiceList(monthRange[0],monthRange[1]);
			}
			if (tempRecords != null) {
				records.addAll(tempRecords);
			}
			//分批插入
			if (null != records && !records.isEmpty()){
				batchCount = records.size() / batchSize;
				for (int j = 0; j < batchCount; j++) {
					tempRecords = records.subList(j * batchSize, (j + 1) * batchSize);
					debugService.debugInsertIssue(wxConfig,tempRecords);
				}
			}
		}
		log.info("微信智能表格发票数据插入完成");
		log.info("微信智能表格合同数据插入开始...");
		//开始处理合同信息，先获取合同数，然后分批次插入数据，每批次1000条
		int contractCount = baseMapper.selectContractListCount();
		batchCount = contractCount / batchSize;
		if (contractCount % batchSize != 0) {
			batchCount++;
			batchSize = contractCount / batchCount;
			for (int i = 0; i < batchCount; i++) {
				tempRecords = baseMapper.selectContractList(i * batchSize, (i + 1) * batchSize);
				if (tempRecords != null) {
					debugService.debugInsertIssue(wxConfig,tempRecords);
				}
			}
		}
		log.info("微信智能表格合同数据插入完成");
	}
}
