package com.yifu.cloud.plus.v1.ekp.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yifu.cloud.plus.v1.ekp.config.WxConfig;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2025/9/18
 * @Description
 * @Version 1.0
 */
@Log4j2
@Service
public class SmartSheetDebugService {

    @Autowired
    private WeComSmartSheetDebugger debugger;

    /**
     * 调试企业微信智能表格记录添加问题
     *
     */
    public void debugInsertIssue(WxConfig wxConfig,List<Map<String, Object>> records) {
		if (Common.isEmpty( records)){
			log.info("数据为空");
			return;
		}
		String corpId = "wwbcb090af0dfe50e5";
		//  HR审批应用 agentid: 1000009，corpSecret：R0nKkvsY-oF41fuQvUXZ-kFG3_g_Ce0bpZt6mByx524
		String corpSecret = "16kqEL_eU-ARwYyqLgEBWHgxm8gXVnkzv_eJMLy9Np";
		String docId = "dcTSMCj4lWV9MEP7lquZacOY8WS4g-iHxP_jVYA02tdYwb2YYc3BpDR8NrFWkEngHUg8abET4eTIpo9Zv-571NEA";
		String sheetId = "q979lj";

        log.info("=== 开始调试企业微信智能表格记录添加问题 ===");

        // 1. 获取并打印表格字段信息
       log.info("=== 表格字段信息 ===");
        List<WeComSmartSheetDebugger.FieldInfo> fields = debugger.getSheetFields(wxConfig,corpId, corpSecret, docId, sheetId);
        if (fields.isEmpty()) {
            log.info("未能获取到表格字段信息，请检查参数是否正确");
            return;
        }

        for (WeComSmartSheetDebugger.FieldInfo field : fields) {
			log.info("字段ID: " + field.getFieldId() +
                    ", 字段标题: '" + field.getTitle() + "'" +
                    ", 字段类型: " + field.getType());
        }
        // 3. 验证字段匹配性
        log.info("\n=== 字段匹配性验证 ===");
        List<String> mismatches = debugger.validateFields(wxConfig,corpId, corpSecret, docId, sheetId, records);
        if (mismatches.isEmpty()) {
			log.info("所有字段都匹配");
        } else {
			log.info("以下字段不匹配:");
            for (String mismatch : mismatches) {
				log.info("- " + mismatch);
            }
			log.info("请根据以上信息修正数据后重试");
            return;
        }

        // 4. 测试插入数据并查看详细响应
		log.info("\n=== 测试数据插入 ===");
        String response = debugger.testInsertData(wxConfig,corpId, corpSecret, docId, sheetId, records);
		log.info("API响应: " + response);

		log.info("\n=== 调试完成 ===");
    }
}