/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 电子档案信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_elec_employee_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "电子档案信息表")
public class TElecEmployeeInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description ="员工姓名")
	@NotNull(message = "员工姓名不能为空")
	@Size(max = 20, message = "员工姓名不可超过20位")
    private String empName;

	/**
	 * 身份证号码
	 */
	@Schema(description ="身份证号码")
	@NotNull(message = "身份证号码不能为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
    private String empIdcard;

	/**
	 * 员工编码
	 */
	@Schema(description ="员工编码")
	@TableField(exist = false)
    private String empNo;

    /**
     * 单位名称
     */
    @Schema(description ="单位名称")
	@TableField(exist = false)
    private String unitName;

    /**
     * 项目名称
     */
    @Schema(description ="项目名称")
	@TableField(exist = false)
    private String deptName;

    /**
     * 项目编码
     */
    @Schema(description ="项目编码")
	@TableField(exist = false)
    private String deptNo;

    /**
     * 资料类型
     */
    @Schema(description ="资料类型")
	@NotNull(message = "资料类型不能为空")
	@Size(max = 2, message = "身资料类型不可超过2位")
    private String dataType;

	/**
	 * 是否删除 0否/1是
	 */
	@Schema(description ="是否删除 0否/1是")
	private String deleteFlag;

	/**
	 * @Author fxj
	 * @Description 附件ID
	 * @Date 14:53 2022/6/21
	 **/
	@TableField(exist = false)
	private String attaIds;
}
