package com.yifu.cloud.plus.v1.business.service.salary.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsPersonal;
import com.yifu.cloud.plus.v1.business.mapper.salary.TSalaryStatisticsPersonalMapper;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalQuery;
import com.yifu.cloud.plus.v1.business.service.salary.TSalaryStatisticsPersonalService;
import com.yifu.cloud.plus.v1.business.util.BusinessCommonUtils;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsPersonalVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 个人薪资变动统计表 service实现层
 *
 * @author: wangweiguo
 * @date: 2021-09-07
 */
@Service
public class TSalaryStatisticsPersonalServiceImpl extends ServiceImpl<TSalaryStatisticsPersonalMapper, TSalaryStatisticsPersonal>
        implements TSalaryStatisticsPersonalService {

    /**
     * 个人统计分页查询: 个人统计条件分页查询
     *
     * @param query 查询条件
     * @return: R<IPage < TSalaryStatisticsPersonalVO>>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Override
    public R<IPage<TSalaryStatisticsPersonalVO>> getListByPage(TSalaryStatisticsPersonalPageQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        Page<TSalaryStatisticsPersonalVO> page = new Page<>(query.getCurrent(), query.getSize());
        page.setOrders(query.getOrders());
        page = this.baseMapper.getListByPage(page, query);
        return R.ok(page, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 个人统计列表查询: 个人统计条件查询
     *
     * @param query 个人统计查询条件
     * @return: R<List < TSalaryStatisticsPersonalVO>>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Override
    public R<List<TSalaryStatisticsPersonalVO>> getList(TSalaryStatisticsPersonalQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        List<TSalaryStatisticsPersonalVO> list = this.baseMapper.getListByPage(query);
        return R.ok(list, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 个人合计: 条件查询个人合计
     *
     * @param query 个人统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Override
    public R<TSalaryTotalVO> getSumPersonalByParams(TSalaryStatisticsPersonalQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        TSalaryTotalVO salaryTotalVO = this.baseMapper.sumSalaryPerson(query);
        return R.ok(salaryTotalVO, CommonConstants.SEARCH_SUCCESS);
    }

}




