package com.yifu.cloud.plus.v1.csp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.entity.EmployeeRegistration;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationExportVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationHrExportVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeProjectBelongDeptSearchCspVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@Mapper
public interface EmployeeRegistrationMapper extends BaseMapper<EmployeeRegistration> {
    /**
     * 入离职登记表简单分页查询
     * @param employeeRegistration 入离职登记表
     * @return
     */
    IPage<EmployeeRegistration> getEmployeeRegistrationPage(Page<EmployeeRegistration> page, @Param("employeeRegistration") EmployeeRegistrationSearchVo employeeRegistration);

	long selectExportCount(@Param("employeeRegistration") EmployeeRegistrationSearchVo employeeRegistration);

	List<EmployeeRegistrationExportVo> selectExportList(@Param("employeeRegistration") EmployeeRegistrationSearchVo employeeRegistration);

	List<EmployeeRegistrationHrExportVo> selectHrExportList(@Param("employeeRegistration") EmployeeRegistrationSearchVo employeeRegistration);

	// 获取已接收的入离职申请，同步所属部门到项目档案里
	List<TEmployeeProjectBelongDept> getZeroRegistrationByIdCard(@Param("searchCspVo") TEmployeeProjectBelongDeptSearchCspVo searchCspVo);

	// 将数据处理为已处理
	int updateTwoRegistrationByIdCard(@Param("searchCspVo") TEmployeeProjectBelongDeptSearchCspVo searchCspVo);

}
