/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.csp.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.csp.entity.TOperationLog;
import com.yifu.cloud.plus.v1.csp.vo.TOperationLogSearchVo;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 入离职等的操作日志
 *
 * @author hgw
 * @date 2025-02-28 15:18:43
 */
public interface TOperationLogService extends IService<TOperationLog> {
    /**
     * 入离职等的操作日志简单分页查询
     * @param tOperationLog 入离职等的操作日志
     * @return
     */
    IPage<TOperationLog> getTOperationLogPage(Page<TOperationLog> page, TOperationLogSearchVo tOperationLog);

    List<TOperationLog> noPageDiy(TOperationLogSearchVo searchVo);

	/**
	 * @param mainId 关联ID
	 * @param type 传0，就是入离职申请（可以为空）
	 * @param title 标题
	 * @param operationTime 操作时间
	 * @param operationName 操作人
	 * @param remark 备注（可以为空）
	 * @Description:  新增日志
	 * @Author: hgw
	 * @Date: 2025/2/28 16:13
	 * @return: com.yifu.cloud.plus.v1.csp.entity.TOperationLog
	 **/
	TOperationLog saveLog(String mainId, String type, String title, LocalDateTime operationTime, String operationName, String remark);

}
