package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpFundInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushFundParam;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 社保明细推送
 * @author huyc
 * @date 2024-02-28 17:01:22
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpFundPush" )
@Tag(name = "公积金明细推送")
public class TEkpFundInfoController {

	private final EkpFundInfoService fundInfoService;

	/**
	 * @param unPushList
	 * @Description: 推送公积金明细数据
	 * @Author: huyc
	 * @Date: 2024/3/6
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/pushFundInfoToEkp")
	public EkpSocialPushInfoVo pushFundInfoToEkp(@RequestBody List<EkpPushFundParam> unPushList) {
		return fundInfoService.pushFundInfoToEkp(unPushList);
	}
}
