/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 商险地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:32:05
 */
@Data
public class TInsuranceAreaResVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 登录人id
	 */
	@NotBlank(message = "登录人id 不能为空")
	@Length(max = 32, message = "登录人id 不能超过32 个字符")
	@ExcelAttribute(name = "登录人id", isNotEmpty = true, errorInfo = "登录人id 不能为空", maxLength = 32)
	@Schema(description = "登录人id")
	@ExcelProperty("登录人id")
	private String userId;
	/**
	 * 档案-省
	 */
	@NotBlank(message = "档案-省 不能为空")
	@ExcelAttribute(name = "档案-省", isNotEmpty = true, errorInfo = "档案-省 不能为空")
	@Schema(description = "档案-省")
	@ExcelProperty("档案-省")
	private String province;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市")
	@Schema(description = "档案-市")
	@ExcelProperty("档案-市")
	private String city;

}
