package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceAlert;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceWarnMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceWarnService;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @author huych
 * @description 针对表【t_insurance_alert(商险到期提醒表)】的数据库操作Service实现
 * @date 2024-08-26 14:20:16
 */
@Service
public class TInsuranceWarnServiceImpl extends ServiceImpl<TInsuranceWarnMapper, TInsuranceAlert> implements TInsuranceWarnService {

	@Override
	public void createInsuranceAlert() {
		//批量删除所有未忽略的提醒数据
		baseMapper.delete(Wrappers.<TInsuranceAlert>query().lambda()
				.eq(TInsuranceAlert::getExpireIgnoreFlag, CommonConstants.ONE_STRING));
		//批量生成或者更新商险到期提醒数据
		List<TInsuranceAlert> list = baseMapper.selectInsuranceAlert();
		this.saveOrUpdateBatch(list);
	}
}
