/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.msg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.msg.entity.TMessageInfo;
import com.yifu.cloud.plus.v1.msg.service.TMessageInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 消息提醒
 *
 * @author huyc
 * @date 2023-07-26 14:19:33
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tmessageinfo" )
@Tag(name = "消息提醒管理")
public class TMessageInfoController {

    private final TMessageInfoService tMessageInfoService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tMessageInfo 消息提醒
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TMessageInfo>> getTMessageInfoPage(Page<TMessageInfo> page, TMessageInfo tMessageInfo) {
        return new R<>(tMessageInfoService.getTMessageInfoPage(page,tMessageInfo));
    }

    /**
     * 通过id查询消息提醒
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TMessageInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tMessageInfoService.getById(id));
    }

    /**
     * 新增消息提醒
     * @param tMessageInfo 消息提醒
     * @return R
     */
    @Operation(summary = "新增消息提醒", description = "新增消息提醒")
    @SysLog("新增消息提醒" )
    @PostMapping("/saveMessageInfo")
    public R<Boolean> save(@RequestBody TMessageInfo tMessageInfo) {
        return tMessageInfoService.saveMessage(tMessageInfo);
    }

    /**
     * 修改消息提醒
     * @param tMessageInfo 消息提醒
     * @return R
     */
    @Operation(summary = "修改消息提醒", description = "修改消息提醒")
    @SysLog("修改消息提醒" )
    @PutMapping
    public R<Boolean> updateById(@RequestBody TMessageInfo tMessageInfo) {
        return R.ok(tMessageInfoService.updateById(tMessageInfo));
    }

	/**
	 * @Author huyc
	 * @Description 更新消息信息
	 * @Date 14:30 2023/7/26
	 * @Param
	 * @return
	 **/
	@Operation(summary = "更新消息信息", description = "更新消息信息")
	@Inner
	@PostMapping("/inner/updateInnerMessageInfo")
	public void updateInnerMessageInfo(@RequestBody TMessageInfo tMessageInfo) {
		tMessageInfoService.updateMessageInfo(tMessageInfo);
	}

	/**
	 * @Author huyc
	 * @Description 更新消息信息
	 * @Date 14:30 2023/7/26
	 * @Param
	 * @return
	 **/
	@Operation(summary = "更新消息信息", description = "更新消息信息")
	@PostMapping("/updateMessageInfo")
	public void updateMessageInfo(@RequestBody TMessageInfo tMessageInfo) {
		tMessageInfoService.updateMessageInfo(tMessageInfo);
	}

	/**
	 * @Author huyc
	 * @Description 查询消息数量
	 * @Date 14:30 2023/7/26
	 * @Param
	 * @return
	 **/
	@Operation(summary = "查询消息数量", description = "查询消息数量")
	@PostMapping("/selectMessageCount")
	public R<Long> selectMessageCount(@RequestBody TMessageInfo tMessageInfo) {
		return tMessageInfoService.selectMessageCount(tMessageInfo);
	}

    /**
     * 通过id删除消息提醒
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除消息提醒", description = "通过id删除消息提醒")
    @SysLog("通过id删除消息提醒" )
    @DeleteMapping("/{id}" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tMessageInfoService.removeById(id));
    }
}
