package com.yifu.cloud.plus.v1.yifu.permission.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 企业微信出差
 */
@TableName(value = "ekp_qiwei_chuchai")
@Data
@Schema(description = "企业微信出差")
public class EkpQiwiChuchai {

	@TableField(exist = false)
	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键", name = "fdId")
	private String fdId;

	@Schema(description = "审批编号")
	@NotBlank(message = "审批编号不能为空")
	private String fdSpNo;

	@Schema(description = "申请人姓名")
	@NotBlank(message = "申请人姓名不能为空")
	private String fdApplyUserName;

	@Schema(description = "申请人部门")
	@NotBlank(message = "申请人部门不能为空")
	private String fdApplyUserDept;

	@Schema(description = "申请日期")
	@NotNull(message = "申请日期不能为空")
	private LocalDateTime fdApplyDate;

	@Schema(description = "开始日期")
	private LocalDate fdNewBegin;
	@Schema(description = "结束日期")
	private LocalDate fdNewEnd;

	@Schema(description = "出差事由")
	private String fdReason;
	@Schema(description = "随行人员")
	private String fdPerson;
	@Schema(description = "出差地点")
	private String fdAddress;
	@Schema(description = "出发地点")
	private String fdOldAddress;
	@Schema(description = "出行工具")
	private String fdTools;
	@Schema(description = "出差地点级别")
	private String fdAddressLevel;
	@Schema(description = "交通补助")
	private String fdJiaoTong;
	@Schema(description = "餐饮补助")
	private String fdCanYin;
	@Schema(description = "人数")
	private Integer fdRenShu;
	// status 0 初始；1已结算；
	@Schema(description = "结算状态")
	private String fdStatus;
	@Schema(description = "关联结算ID")
	private String fdSettleFormId;

	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	// 企微、HCM
	@Schema(description = "数据源")
	private String fdDataSource;

	// cyx-mvp1.7.0 新增字段：关联差旅费报销编号、岗位级别、业务条线归属、代为发起随行人员出差流程

	@Schema(description = "关联差旅费报销编号")
	private String fdSettleFormCode;

	@Schema(description = "代为发起随行人员出差流程(是，否)")
	private String fdPersonTravelProcess;

	@Schema(description = "岗位级别")
	private String fdPositionLevel;

	@Schema(description = "业务条线归属")
	private String fdBusinessLine;

}
