package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainListVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.ArchivesDaprUtil;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TConfigSalary;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TConfigSalaryMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TConfigSalaryService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @Author fxj
 * @Description 工资报账配置
 * @Date 13:17 2022/8/6
 * @Param
 * @return
**/
@AllArgsConstructor
@Service("tConfigSalaryService")
public class TConfigSalaryServiceImpl extends ServiceImpl<TConfigSalaryMapper, TConfigSalary> implements TConfigSalaryService {

	private final ArchivesDaprUtil archivesDaprUtil;
     /**
      * 工资报账配置简单分页查询
      * @param tConfigSalary 工资报账配置
      * @return
      */
     @Override
     public R<IPage<TConfigSalary>> getTConfigSalaryPage(Page<TConfigSalary> page, TConfigSalary tConfigSalary){
          /* 2023-09-13 段亚玲  按用户组授权，取消内置项目权限
          YifuUser user = SecurityUtils.getUser();
		 TSettleDomainListVo vo = null;
          if (Common.isNotNull(user) && CommonConstants.ONE_STRING.equals(user.getSystemFlag())) {
			  R<TSettleDomainListVo> domainListVoR = archivesDaprUtil.getSettleDomainIdsByUserId(user.getId());
               if (Common.isEmpty(domainListVoR)) {
					return R.failed("调用结算服务失败");
               }
               if (CommonConstants.SUCCESS != domainListVoR.getCode()) {
				   return R.failed("调用结算服务返回失败");
               }
			   vo = domainListVoR.getData();
          }
		  if (Common.isNotNull(vo)){
			  return R.ok(baseMapper.getTConfigSalaryPage(page, tConfigSalary, vo.getDeptIds()));
		  }*/
          return R.ok(baseMapper.getTConfigSalaryPage(page, tConfigSalary, null));
     }

}
