package com.yifu.cloud.plus.v1.yifu.salary.util;

import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsTaxSalaryTwoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 主要执行统计时长较长的方法
 *
 * @author hgw
 * @Date 2022-2-25 10:32:37
 * @Description 多线程的执行demo
 */
@Slf4j
@Component
public class DoStatisticsTask {

	@Autowired
	private TStatisticsTaxSalaryTwoService tStatisticsTaxSalaryTwoService;

	/**
	 * @param declareMonth 申报月（实际数据为上个结算月）
	 * @Description: 核心刷新-年度报账、工资薪金、本期申报
	 * @Author: hgw
	 * @Date: 2022-2-25 10:29:28
	 * @return: void
	 **/
	@Async
	public void doRefreshCore(String declareMonth) {
		tStatisticsTaxSalaryTwoService.doRefreshStatisticsTaxAuto(declareMonth);
	}

}
