/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 *
 *
 * @author huyc
 * @date 2023-07-18 11:38:05
 */
@Data
public class TDispatchSocialPersionReduceExportVo implements Serializable {

	/**
	 * 序号
	 */
	@Schema(description = "序号" )
	@ExcelAttribute(name = "序号" )
	@ExcelProperty("序号")
	private Integer num;
	/**
	 * 职工编码
	 */
	@Schema(description = "职工编码" )
	@ExcelAttribute(name = "职工编码" )
	@ExcelProperty("职工编码")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Schema(description = "姓名" )
	@ExcelAttribute(name = "姓名" )
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 社会保障号码
	 */
	@Schema(description = "社会保障号码（身份证号码）" )
	@ExcelAttribute(name = "社会保障号码（身份证号码）" )
	@ExcelProperty("社会保障号码（身份证号码）")
	private String empIdcard;
	/**
	 * 停止缴费时间
	 */
	@Schema(description = "停止缴费时间" )
	@ExcelAttribute(name = "停止缴费时间" )
	@ExcelProperty("停止缴费时间")
	private String workDate;
	/**
	 * 辞职
	 */
	@Schema(description = "辞职" )
	@ExcelAttribute(name = "辞职" )
	@ExcelProperty("辞职")
	private String typeA;
	/**
	 * 辞退
	 */
	@Schema(description = "辞退" )
	@ExcelAttribute(name = "辞退" )
	@ExcelProperty("辞退")
	private String typeB;
	/**
	 * 参军
	 */
	@Schema(description = "参军" )
	@ExcelAttribute(name = "参军" )
	@ExcelProperty("参军")
	private String typeC;
	/**
	 * 辞退
	 */
	@Schema(description = "上学" )
	@ExcelAttribute(name = "上学" )
	@ExcelProperty("上学")
	private String typeD;
	/**
	 * 辞退
	 */
	@Schema(description = "劳改" )
	@ExcelAttribute(name = "劳改" )
	@ExcelProperty("劳改")
	private String typeE;

	/**
	 * 劳教
	 */
	@Schema(description = "劳教" )
	@ExcelAttribute(name = "劳教" )
	@ExcelProperty("劳教")
	private String typeW;

	/**
	 * 劳教
	 */
	@Schema(description = "除名" )
	@ExcelAttribute(name = "除名" )
	@ExcelProperty("除名")
	private String typeF;
	/**
	 * 人员失踪
	 */
	@Schema(description = "人员失踪" )
	@ExcelAttribute(name = "人员失踪" )
	@ExcelProperty("人员失踪")
	private String typeG;
	/**
	 * 停薪留职
	 */
	@Schema(description = "停薪留职" )
	@ExcelAttribute(name = "停薪留职" )
	@ExcelProperty("停薪留职")
	private String typeH;
	/**
	 * 合同期满
	 */
	@Schema(description = "合同期满" )
	@ExcelAttribute(name = "合同期满" )
	@ExcelProperty("合同期满")
	private String typeZ;
	/**
	 * 解除合同
	 */
	@Schema(description = "解除合同" )
	@ExcelAttribute(name = "解除合同" )
	@ExcelProperty("解除合同")
	private String typeI;
	/**
	 * 统筹内调出
	 */
	@Schema(description = "统筹内调出" )
	@ExcelAttribute(name = "统筹内调出" )
	@ExcelProperty("统筹内调出")
	private String typeJ;

	/**
	 * 调出统筹范围
	 */
	@Schema(description = "调出统筹范围" )
	@ExcelAttribute(name = "调出统筹范围" )
	@ExcelProperty("调出统筹范围")
	private String typeK;

	/**
	 * 退休
	 */
	@Schema(description = "退休" )
	@ExcelAttribute(name = "退休" )
	@ExcelProperty("退休")
	private String typeL;

	/**
	 * 死亡
	 */
	@Schema(description = "死亡" )
	@ExcelAttribute(name = "死亡" )
	@ExcelProperty("死亡")
	private String typeM;
	/**
	 * 出国定居
	 */
	@Schema(description = "出国定居" )
	@ExcelAttribute(name = "出国定居" )
	@ExcelProperty("出国定居")
	private String typeN;
	/**
	 * 港澳台定居
	 */
	@Schema(description = "港澳台定居" )
	@ExcelAttribute(name = "港澳台定居" )
	@ExcelProperty("港澳台定居")
	private String typeO;
	/**
	 * 退保
	 */
	@Schema(description = "退保" )
	@ExcelAttribute(name = "退保" )
	@ExcelProperty("退保")
	private String typeP;
	/**
	 * 其他
	 */
	@Schema(description = "其他" )
	@ExcelAttribute(name = "其他" )
	@ExcelProperty("其他")
	private String typeQ;

	/**
	 * 学历
	 */
	@Schema(description = "备注")
	@ExcelAttribute(name = "备注" )
	@ExcelProperty("备注")
	private String remark;
}
