/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysPost;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysRole;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lengleng
 * @date 2019/2/1
 */
@Data
public class UserCspVO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 用户Id
	 */
	private String userId;
	/**
	 * 用户名
	 */
	@NotBlank(message = "用户名 不能为空")
	private String username;

	/**
	 * 用户昵称
	 */
	@NotBlank(message = "用户昵称 不能为空")
	private String nickname;

	/**
	 * 手机号码
	 */
	@NotBlank(message = "手机号码 不能为空")
	private String phone;

	/**
	 * 部门ID
	 */
	private Long deptId;
	/**
	 * 部门名称
	 */
	@NotBlank(message = "部门名称 不能为空")
	@Schema(description = "部门名称")
	private String deptName;

	//关系表数据开始
	@NotBlank(message = "关联项目编码 不能为空")
	@Schema(description = "关联项目编码")
	private String projectNo;

	@NotBlank(message = "关联项目名称 不能为空")
	@Schema(description = "关联项目名称")
	private String projectName;

	@NotBlank(message = "关联项目ID 不能为空")
	@Schema(description = "关联项目ID")
	private String projectId;

	@Schema(description = "归属系统 0 yifu-mvp 1 yifu-csp")
	private String client;

	@NotBlank(message = "账号类型 不能为空")
	@Schema(description = "账号类型：0 管理员， 1 普通成员")
	private String userType;
	/**
	 * 邮箱
	 */
	@Schema(description = "邮箱")
	private String email;

	/**
	 * 用户分组
	 */
	@Schema(description = "用户分组")
	private String userGroup;

}
