/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDept;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.DeptSortVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysDeptVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 部门管理 Mapper 接口
 * </p>
 *
 * @author lengleng
 * @since 2019/2/1
 */
@Mapper
public interface SysDeptMapper extends BaseMapper<SysDept> {

	/**
	 * 关联dept——relation
	 * @return 数据列表
	 */
	List<SysDept> listDepts();

	SysDept selectCountId(@Param("deptId")Long deptId);

	int updateDeptById(@Param("dept") SysDept dept);

	SysDept selectDeptDn(@Param("deptDn")String deptDn);

	List<SysDept> getDeptListByDeptId(@Param("deptIdSplit") String deptIdSplit, @Param("deptId") Long deptId);

	/**
	 * 客户服务平台——查询部门管理数据
	 *
	 * @param dept 部门信息
	 */
	List<SysDeptVo> cspDeptList(@Param("dept") SysDeptVo dept);

	/**
	 * 客户服务平台——查询部门管理数据(带部门下人数)
	 *
	 */
	List<SysDeptVo> cspDeptUserList(@Param("dept") SysDeptVo dept);

	/**
	 * 客户服务平台——根据部门集合查询部门管理数据
	 *
	 * @param dept 部门信息
	 */
	List<SysDeptVo> cspDeptListByDeptIdSet(@Param("dept") SysDeptVo dept, @Param("departIdSet") Set<String> departIdSet);

	/**
	 * 客户服务平台——查询同项目下同级部门
	 *
	 */
	SysDept checkDeptNameUnique(@Param("projectNo") String projectNo, @Param("deptName") String deptName, @Param("parentId") Long parentId);

	/**
	 * 客户服务平台——是否存在子节点
	 *
	 * @param deptId 部门ID
	 * @return 结果
	 */
	int hasChildByDeptId(@Param("deptId") Long deptId);

	/**
	 * 客户服务平台——查询部门是否存在用户
	 *
	 * @param deptId 部门ID
	 * @return 结果
	 */
	int checkDeptExistUser(@Param("deptId") Long deptId);

	int cspDeptCount(@Param("projectNo") String projectNo);


    void batchUpdateSort(@Param("moveVos")List<DeptSortVo> moveVos);

	List<SysDept> cspDelDeptIds(@Param("projectNo") String projectNo);


}
