/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUserDeptPermission;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.UserCspVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.UserPermissionVo;

import java.util.List;


/**
 * 项目下用户部门及权限
 *
 * @author chenyuxi
 * @since 1.9.7
 */
public interface SysUserDeptPermissionService extends IService<SysUserDeptPermission> {


	/**
	 * 获取项目下用户的部门，数据权限配置信息
	 * @param projectNo 项目编号
	 * @param userId    用户ID
	 *
	 * @return SysUserDeptPermission
	 */
	SysUserDeptPermission getInfo(String projectNo, String userId);

	/**
	 * 客户服务平台——用户权限控制
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	R<String> saveUserPermission(SysUserDeptPermission sysUserDeptPermission);

	/**
	 * 客户服务平台——绑定项目
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	R<String> relationUser(SysUserDeptPermission sysUserDeptPermission);

	List<UserPermissionVo> getUserPermission(String userId);

	R<Boolean> saveAsso(UserCspVO entity);

	R<Boolean> updateByIdAsso(UserCspVO entity);

    R<Boolean> removeUserDeptPermissionById(String userId, String projectNo);
}
