package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.alibaba.fastjson.JSON;
import com.fasc.open.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddReqLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.*;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.CheckedException;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @auther huyc
 * @date 2022/6/29
 */
@EnableConfigurationProperties({DaprUpmsProperties.class})
@RestController
@RequiredArgsConstructor
@RequestMapping("/fasc")
@Tag(name = "法大大专业版接口")
public class FascController {

    @Autowired
    private FascService fascService;
    @Autowired
    private FddReqLogService reqLogService;
    @Autowired
    private FddPersonAccountService fddPersonAccountService;
    @Autowired
    private FddContractInfoService fddContractInfoService;
    @Autowired
    private FddCompanyInfoService fddCompanyInfoService;
    @Autowired
    private FddContractAttachInfoService fddContractAttachInfoService;
    @Autowired
    private TEmployeeContractInfoService employeeContractInfoService;

	/**
	 * @param templateName 签署任务模板名称，如果传了该参数，会根据名称模糊匹配查询，长度最大100个字符。
	 * @Description: 获取模板
	 * @Author: hgw
	 * @Date: 2025/9/26 16:21
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "获取模板")
	@GetMapping("/getTemplate" )
	public R<String> getTemplate(@RequestParam(required = false) String templateName) throws ApiException {
		return fascService.getTemplate(templateName);
	}

	/**
	 * 保存请求参数日志
	 *
	 * @param request
	 */
	private void saveReqLog(HttpServletRequest request) {
		Map<String, String[]> parameterMap = request.getParameterMap();
		FddReqLog fddReqLog = new FddReqLog();
		fddReqLog.setResData(JSON.toJSONString(parameterMap));
		fddReqLog.setMethodName(Thread.currentThread().getStackTrace()[1].getMethodName());
		fddReqLog.setClassName(Thread.currentThread().getStackTrace()[1].getClassName());
		reqLogService.save(fddReqLog);
	}

    //验证签名
    public void checkSign(HttpServletRequest request) throws Exception {
       /* Map<String, String> paraMap = new HashMap<>(8);
        paraMap.put(GlobalConstants.FDD_APPID, request.getHeader(GlobalConstants.FDD_APPID));
        paraMap.put(GlobalConstants.FDD_SIGN_TYPE, request.getHeader(GlobalConstants.FDD_SIGN_TYPE));
        paraMap.put(GlobalConstants.FDD_TIMESTAMP, request.getHeader(GlobalConstants.FDD_TIMESTAMP));
        paraMap.put(GlobalConstants.FDD_NONCE, request.getHeader(GlobalConstants.FDD_NONCE));
        paraMap.put(FDD_EVENT, request.getHeader(FDD_EVENT));
        String fddBizContent = request.getParameter(FDD_BIZ_CONTENT);
        paraMap.put(FDD_BIZ_CONTENT, fddBizContent);
        //得到排序后的字符串，FddCryptUtil为法大大提供得签名工具类
        String sortParam = FddCryptUtil.sortParameters(paraMap);
        //计算之后得到签名 该签名需要放到请求头
        String signature = FddCryptUtil.sign(sortParam, request.getHeader(GlobalConstants.FDD_TIMESTAMP), fddConfigProperties.getAppKey());
        if (StringUtils.equals(signature, request.getHeader(GlobalConstants.FDD_API_SIGN))) {
            FddReqLog fddReqLog = new FddReqLog();
            paraMap.put(GlobalConstants.FDD_TIMESTAMP, request.getHeader(GlobalConstants.FDD_TIMESTAMP));
            fddReqLog.setReqData(signature);
            fddReqLog.setResData(JSON.toJSONString(paraMap));
            fddReqLog.setMethodName(Thread.currentThread().getStackTrace()[1].getMethodName());
            fddReqLog.setClassName(Thread.currentThread().getStackTrace()[1].getClassName());
            reqLogService.save(fddReqLog);
            return;
        }*/
        throw new CheckedException("签名异常");
    }

}
