/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzPushEntry;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzPushEntryService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzPushEntrySearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;


/**
 * 瓜子系统交互任务跟进表
 *
 * @author cyx
 * @date 2025-07-09 17:03:50
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzpushentry" )
@Tag(name = "瓜子系统交互任务跟进表管理")
public class TGzPushEntryController {

    private final TGzPushEntryService tGzPushEntryService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tGzPushEntry 瓜子系统交互任务跟进表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TGzPushEntrySearchVo>> getTGzPushEntryPage(Page<TGzPushEntry> page, TGzPushEntrySearchVo tGzPushEntry) {
        return  new R<>(tGzPushEntryService.getTGzPushEntryPage(page,tGzPushEntry));
    }

	/**
	 * 任务推送重试
	 * @param tGzPushEntry 瓜子系统交互任务跟进表
	 * @return R
	 */
	@Operation(summary = "任务推送重试")
	@SysLog("任务推送重试" )
	@PostMapping("/retry")
	public R<String> retryPushEntry(@RequestBody TGzPushEntry tGzPushEntry) {
		return tGzPushEntryService.retryPushEntry(tGzPushEntry);
	}
}
