/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fadada.api.bean.req.BaseReq;
import com.fadada.api.bean.rsp.BaseRsp;
import com.fadada.api.bean.rsp.account.GetAccessObjectInfoRsp;
import com.fadada.api.client.AccountClient;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddCompanyInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddCompanyInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddCompanyInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddReqLogService;
import com.yifu.cloud.plus.v1.yifu.archives.utils.FddUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 法大大企业接入方信息
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@Service
@RequiredArgsConstructor
public class FddCompanyInfoServiceImpl extends ServiceImpl<FddCompanyInfoMapper, FddCompanyInfo> implements FddCompanyInfoService {

	private final FddUtil fddUtil;

	private final FddReqLogService reqLogService;

	/**
	 * 法大大企业接入方信息简单分页查询
	 *
	 * @param fddCompanyInfo 法大大企业接入方信息
	 * @return
	 */
	@Override
	public IPage<FddCompanyInfo> getFddCompanyInfoPage(Page<FddCompanyInfo> page, FddCompanyInfo fddCompanyInfo) {
		long records = this.count();
		if (records == CommonConstants.ZERO_INT) {
			try {
				//法大大接入方信息
				BaseReq req = new BaseReq();
				req.setToken(fddUtil.getToken());
				//发送请求
				AccountClient accountClient = new AccountClient(fddUtil.getFadadaApiClient());
				BaseRsp<GetAccessObjectInfoRsp> rsp = accountClient.getAccessObjectInfo(req);
				reqLogService.saveLog(Thread.currentThread().getStackTrace()[1].getClassName(),Thread.currentThread().getStackTrace()[1].getMethodName(),req, rsp);
				GetAccessObjectInfoRsp data = rsp.getData();
				//插入信息
				if (StringUtils.equals(rsp.getCode(), FddUtil.SUCCESS)) {
					FddCompanyInfo companyInfo = new FddCompanyInfo();
					companyInfo.setCompanyName(data.getCompanyName());
					companyInfo.setCompanyUnionId(data.getCompanyUnionId());
					companyInfo.setManagerName(data.getManagerName());
					companyInfo.setManagerUnionId(data.getManagerUnionId());
					this.save(companyInfo);
				}
			} catch (ApiException e) {
				e.printStackTrace();
			}
		}
		return baseMapper.getFddCompanyInfoPage(page, fddCompanyInfo);
	}
}
