package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 社保待购买表
 *
 * @author huych
 * @date 2025-09-30 16:40:07
 */
@Data
public class TDispatchInfoPreExportVo extends RowIndex implements Serializable {
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户")
	@Schema(description = "社保户")
	@ExcelProperty("社保户")
	private String socialHouseholdName;
	/**
	 * 备案基数
	 */
	@ExcelAttribute(name = "备案基数")
	@Schema(description = "备案基数")
	@ExcelProperty("备案基数")
	private String recordBase;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期")
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	private String joinLeaveDate;
	/**
	 * 合同签署状态 0已签署 1未签署
	 */
	@ExcelAttribute(name = "合同签署状态")
	@Schema(description = "合同签署状态 0已签署 1未签署")
	@ExcelProperty("合同签署状态")
	private String contractStatus;

	/**
	 * 社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败
	 */
	@ExcelAttribute(name = "社保购买状态")
	@Schema(description = "社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败")
	@ExcelProperty("社保购买状态")
	private String processStatus;
	/**
	 * 预计派单时间
	 */
	@ExcelAttribute(name = "预计派单时间")
	@Schema(description = "预计派单时间")
	@ExcelProperty("预计派单时间")
	private LocalDateTime expectedCollectionTime;
	/**
	 * 前端客服姓名
	 */
	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;

}
