package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfoPre;
import com.yifu.cloud.plus.v1.yifu.social.service.TDispatchInfoPreService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchInfoPreSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 社保待购买表
 *
 * @author huych
 * @date 2025-09-30 16:40:07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tdispatchinfopre")
@Tag(name = "社保待购买表管理")
public class TDispatchInfoPreController {

	private final TDispatchInfoPreService tDispatchInfoPreService;

	private final MenuUtil menuUtil;

	/**
	 * 简单分页查询
	 *
	 * @param page             分页对象
	 * @param tDispatchInfoPre 社保待购买表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TDispatchInfoPre>> getTDispatchInfoPrePage(Page<TDispatchInfoPre> page, TDispatchInfoPreSearchVo tDispatchInfoPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tDispatchInfoPre);
		return new R<>(tDispatchInfoPreService.getTDispatchInfoPrePage(page, tDispatchInfoPre));
	}

	/**
	 * 不分页查询
	 *
	 * @param tDispatchInfoPre 社保待购买表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/getNoPageList")
	public R<List<TDispatchInfoPre>> getTDispatchInfoPreNoPage(@RequestBody TDispatchInfoPreSearchVo tDispatchInfoPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tDispatchInfoPre);
		return R.ok(tDispatchInfoPreService.getNoPageList(tDispatchInfoPre));
	}

	/**
	 * 通过id查询社保待购买表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TDispatchInfoPre> getById(@PathVariable("id") String id) {
		return R.ok(tDispatchInfoPreService.getById(id));
	}

	/**
	 * 修改社保待购买表
	 *
	 * @param tDispatchInfoPre 社保待购买表
	 * @return R
	 */
	@Operation(summary = "修改社保待购买表", description = "修改社保待购买表")
	@SysLog("修改社保待购买表")
	@PutMapping
	public R<Boolean> updateById(@RequestBody TDispatchInfoPre tDispatchInfoPre) {
		return R.ok(tDispatchInfoPreService.updateById(tDispatchInfoPre));
	}

	/**
	 * 通过id删除社保待购买表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除社保待购买表", description = "通过id删除社保待购买表：hasPermission('social_tdispatchinfopre_del')")
	@SysLog("通过id删除社保待购买表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_tdispatchinfopre_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tDispatchInfoPreService.removeById(id));
	}

	/**
	 * 社保待购买表 批量导出
	 *
	 * @author huych
	 * @date 2025-09-30 16:40:07
	 **/
	@Operation(description = "导出社保待购买表")
	@PostMapping("/export")
	public void export(HttpServletResponse response, @RequestBody TDispatchInfoPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tDispatchInfoPreService.listExport(response, searchVo);
	}

	/**
	 * 社保待购买信息单个/批量确认
	 * @author huych
	 * @date 2025-10-09 10:25:13
	 **/
	@Operation(description = "社保待购买信息单个/批量确认")
	@PostMapping("/confirm")
	public R confirm(@RequestBody List<String> idList) {
		return tDispatchInfoPreService.confirm(idList);
	}

	/**
	 * 社保待购买数量查询
	 * @param searchVo 社保待购买任务表
	 * @return
	 */
	@Operation(description = "社保待购买数量查询")
	@GetMapping("/getListCount")
	public R getListCount(TDispatchInfoPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		return R.ok(tDispatchInfoPreService.getDispatchInfoCount(searchVo));
	}

	/**
	 * 新增社保待购买
	 * @author huych
	 * @date 2025-10-10 9:26:35
	 **/
	@Operation(description = "新增社保待购买")
	@Inner
	@PostMapping("/saveSocialPreInfo")
	public Boolean saveSocialPreInfo(@RequestBody EmployeeRegistrationPreVo preVo) {
		return tDispatchInfoPreService.saveSocialPreInfo(preVo);
	}
}
