package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfoPre;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchInfoPreSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 社保待购买表
 *
 * @author huych
 * @date 2025-09-30 16:40:07
 */
public interface TDispatchInfoPreService extends IService<TDispatchInfoPre> {
    /**
     * 社保待购买表简单分页查询
     * @param tDispatchInfoPre 社保待购买表
     * @return
     */
    IPage<TDispatchInfoPre> getTDispatchInfoPrePage(Page<TDispatchInfoPre> page, TDispatchInfoPreSearchVo tDispatchInfoPre);

	/**
	 * 社保待购买批量导出
	 * @param searchVo 社保待购买信息
	 * @return
	 */
    void listExport(HttpServletResponse response, TDispatchInfoPreSearchVo searchVo);

    List<TDispatchInfoPre> getNoPageList(TDispatchInfoPreSearchVo searchVo);

	/**
	 * 社保待购买单个/批量确认
	 * @param idList id集合
	 * @return
	 */
	R confirm(List<String> idList);

	/**
	 * 查询社保待购买数量
	 * @param searchVo 查询社保待购买vo
	 * @return
	 */
	long getDispatchInfoCount(TDispatchInfoPreSearchVo searchVo);

	/**
	 * 新增社保待购买信息
	 * @param preVo
	 * @return
	 */
	Boolean saveSocialPreInfo(EmployeeRegistrationPreVo preVo);
}
