/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysGuaziBankBranch;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysGuaziBankBranchService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;


/**
 * 瓜子银行支行信息
 *
 * @author chenyx
 * @date 2025-06-17 09:43:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysguazibankbranch")
@Tag(name = "瓜子银行支行信息管理")
public class SysGuaziBankBranchController {

	private final SysGuaziBankBranchService sysGuaziBankBranchService;

	/**
	 * 简单分页查询
	 *
	 * @param page               分页对象
	 * @param sysGuaziBankBranch 瓜子银行支行信息
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysGuaziBankBranch>> getSysGuaziBankBranchPage(Page<SysGuaziBankBranch> page, SysGuaziBankBranch sysGuaziBankBranch) {
		return new R<>(sysGuaziBankBranchService.getSysGuaziBankBranchPage(page, sysGuaziBankBranch));
	}

	/**
	 * 拉取瓜子支行信息
	 * @return R
	 */
	@SysLog("拉取瓜子支行信息")
	@PostMapping("/pushBankBranck")
	public R pushBankBranckTest() {
//		String startDay = "2020-01-01";
//		String startTime = startDay+" 00:00:00";
//		String endDay = "2025-07-12";
//		String endTime = endDay+" 00:00:00";
//		Integer pageNum = 173;

		String startDay = DateUtil.addDay(-1);
		String startTime = startDay+" 00:00:00";
		String endDay = DateUtil.addDay(0);
		String endTime = endDay+" 00:00:00";
		Integer pageNum = 1;
		return sysGuaziBankBranchService.pushBankBranck(startTime, endTime, pageNum);
	}

	/**
	 * 拉取瓜子支行信息
	 * @return R
	 */
	@SysLog("拉取瓜子支行信息")
	@PostMapping("/inner/pushBankBranck")
	@Inner
	public R pushBankBranck() {
		String startDay = DateUtil.addDay(-1);
		String startTime = startDay+" 00:00:00";
		String endDay = DateUtil.addDay(0);
		String endTime = endDay+" 00:00:00";
		Integer pageNum = 1;
		return sysGuaziBankBranchService.pushBankBranck(startTime, endTime, pageNum);
	}

}
