/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 预入职-员工职业资格信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_professional_qualification")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工职业资格信息表")
public class TPreEmpProfessionalQualification extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工主键
	 */
	@ExcelAttribute(name = "员工主键", isNotEmpty = true, errorInfo = "员工主键不能为空", maxLength = 32)
	@NotBlank(message = "员工主键不能为空")
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelProperty("员工主键")
	@Schema(description = "员工主键")
	private String empId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelProperty("员工编码")
	@Schema(description = "员工编码")
	private String empCode;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 资格类型
	 */
	@ExcelAttribute(name = "资格类型", isNotEmpty = true, errorInfo = "资格类型不能为空", maxLength = 32)
	@NotBlank(message = "资格类型不能为空")
	@Length(max = 32, message = "资格类型不能超过32个字符")
	@ExcelProperty("资格类型")
	@Schema(description = "资格类型")
	private String qualificationType;
	/**
	 * 资格等级
	 */
	@ExcelAttribute(name = "资格等级", isNotEmpty = true, errorInfo = "资格等级不能为空", maxLength = 32)
	@NotBlank(message = "资格等级不能为空")
	@Length(max = 32, message = "资格等级不能超过32个字符")
	@ExcelProperty("资格等级")
	@Schema(description = "资格等级")
	private String qualificationLevel;
	/**
	 * 证书编号
	 */
	@ExcelAttribute(name = "证书编号", maxLength = 50)
	@Length(max = 50, message = "证书编号不能超过50个字符")
	@ExcelProperty("证书编号")
	@Schema(description = "证书编号")
	private String certificationNo;
	/**
	 * 获取方式
	 */
	@ExcelAttribute(name = "获取方式", maxLength = 32)
	@Length(max = 32, message = "获取方式不能超过32个字符")
	@ExcelProperty("获取方式")
	@Schema(description = "获取方式")
	private String obtainType;
	/**
	 * 评定机构
	 */
	@ExcelAttribute(name = "评定机构", maxLength = 50)
	@Length(max = 50, message = "评定机构不能超过50个字符")
	@ExcelProperty("评定机构")
	@Schema(description = "评定机构")
	private String assessmentUnit;
	/**
	 * 申报年度
	 */
	@ExcelAttribute(name = "申报年度", maxLength = 32)
	@Length(max = 32, message = "申报年度不能超过32个字符")
	@ExcelProperty("申报年度")
	@Schema(description = "申报年度")
	private String declareYear;
	/**
	 * 是否最高资格0是/1否
	 */
	@ExcelAttribute(name = "是否最高资格0是/1否", isNotEmpty = true, errorInfo = "是否最高资格0是/1否不能为空", maxLength = 1)
	@NotBlank(message = "是否最高资格0是/1否不能为空")
	@Length(max = 1, message = "是否最高资格0是/1否不能超过1个字符")
	@ExcelProperty("是否最高资格0是/1否")
	@Schema(description = "是否最高资格0是/1否")
	private String heightIdentification;
	/**
	 * 0删除作废1正常
	 */
	@ExcelAttribute(name = "0删除作废1正常", maxLength = 1)
	@Length(max = 1, message = "0删除作废1正常不能超过1个字符")
	@ExcelProperty("0删除作废1正常")
	@Schema(description = "0删除作废1正常")
	private String deleteFlag;
	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Length(max = 200, message = "备注不能超过200个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

	/**
	 * @author chenyuxi
	 * @since  1.9.6
	 **/
	@Schema(description = "是否有职业资格证书0是/1否")
	private String haveQualification;

	/**
	 * @Description: 执业资格证书
	 * @Author: hgw
	 * @Date: 2024/6/20 15:11
	 * @return:
	 **/
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

}
