package com.yifu.cloud.plus.v1.business.query.vacation;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 假期监控清零日志表 分页查询query
 * @author: wangweiguo
 * @date: 2021-08-16
*/
@Setter
@Getter
@ToString
public class TVacationMonitorClearLogQuery implements Serializable  {
    /**
    * 当前页码 默认为1
    */
	@Schema(description = "当前页码 默认为1")

	long current = 1;

    /**
    * 每页数量 默认为10
    */
	@Schema(description = "每页数量 默认为10")
	long size = 10;

    /**
    * 排序字段
    */
	@Schema(description = "排序字段")
	List<OrderItem> orders;
}

