/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 发放日志(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Data
@TableName("ekp_bank_grant_log")
@Schema(description = "发放日志(银企付款任务)")
public class EkpBankGrantLog {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 关联银企付款表主键
	 */
	@ExcelAttribute(name = "关联银企付款表主键", isNotEmpty = true, errorInfo = "关联银企付款表主键不能为空", maxLength = 36)
	@NotBlank(message = "关联银企付款表主键不能为空")
	@Length(max = 36, message = "关联银企付款表主键不能超过36个字符")
	@ExcelProperty("关联银企付款表主键")
	@Schema(description = "关联银企付款表主键")
	private String fdParentId;
	/**
	 * 代发批次号
	 */
	@ExcelAttribute(name = "代发批次号", maxLength = 20)
	@Length(max = 20, message = "代发批次号不能超过20个字符")
	@ExcelProperty("代发批次号")
	@Schema(description = "代发批次号")
	private String fdBatchNumber;
	/**
	 * 批量包名称
	 */
	@ExcelAttribute(name = "批量包名称", maxLength = 50)
	@Length(max = 50, message = "批量包名称不能超过50个字符")
	@ExcelProperty("批量包名称")
	@Schema(description = "批量包名称")
	private String fdBatchPackage;
	/**
	 * 付款账号
	 */
	@ExcelAttribute(name = "付款账号", maxLength = 50)
	@Length(max = 50, message = "付款账号不能超过50个字符")
	@ExcelProperty("付款账号")
	@Schema(description = "付款账号")
	private String fdPaymentAccount;
	/**
	 * 付款人名称
	 */
	@ExcelAttribute(name = "付款人名称", maxLength = 50)
	@Length(max = 50, message = "付款人名称不能超过50个字符")
	@ExcelProperty("付款人名称")
	@Schema(description = "付款人名称")
	private String fdDrawee;
	/**
	 * 币种
	 */
	@ExcelAttribute(name = "币种", maxLength = 10)
	@Length(max = 10, message = "币种不能超过10个字符")
	@ExcelProperty("币种")
	@Schema(description = "币种")
	private String fdCurrency;
	/**
	 * 业务类型：代发工资等
	 */
	@ExcelAttribute(name = "业务类型：代发工资等", maxLength = 20)
	@Length(max = 20, message = "业务类型：代发工资等不能超过20个字符")
	@ExcelProperty("业务类型：代发工资等")
	@Schema(description = "业务类型：代发工资等")
	private String fdBusinessType;
	/**
	 * 提交时间
	 */
	@ExcelAttribute(name = "提交时间", isDate = true)
	@ExcelProperty("提交时间")
	@Schema(description = "提交时间")
	private LocalDateTime fdSubmitTime;
	/**
	 * 交易时间
	 */
	@ExcelAttribute(name = "交易时间", isDate = true)
	@ExcelProperty("交易时间")
	@Schema(description = "交易时间")
	private Date fdTransactionTime;
	/**
	 * 成功总金额
	 */
	@ExcelAttribute(name = "成功总金额")
	@ExcelProperty("成功总金额")
	@Schema(description = "成功总金额")
	private BigDecimal fdSuccessFee;
	/**
	 * 失败总金额
	 */
	@ExcelAttribute(name = "失败总金额")
	@ExcelProperty("失败总金额")
	@Schema(description = "失败总金额")
	private BigDecimal fdFailFee;
	/**
	 * 总金额
	 */
	@ExcelAttribute(name = "总金额")
	@ExcelProperty("总金额")
	@Schema(description = "总金额")
	private BigDecimal fdSumFee;
	/**
	 * 总笔数
	 */
	@ExcelAttribute(name = "总笔数")
	@ExcelProperty("总笔数")
	@Schema(description = "总笔数")
	private Integer fdTransactionTotal;
	/**
	 * 成功总笔数
	 */
	@ExcelAttribute(name = "成功总笔数")
	@ExcelProperty("成功总笔数")
	@Schema(description = "成功总笔数")
	private Integer fdTransactionSuccessTotal;
	/**
	 * 失败总笔数
	 */
	@ExcelAttribute(name = "失败总笔数")
	@ExcelProperty("失败总笔数")
	@Schema(description = "失败总笔数")
	private Integer fdTransactionFailTotal;

}
