/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.ekp.entity.EkpAlertTable;
import com.yifu.cloud.plus.v1.ekp.entity.EkpInvoiceInfo;
import com.yifu.cloud.plus.v1.ekp.vo.BudgetWarningVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Description EKP的发票信息、合同信息
 * @Date 16:28 2025/9/26
 * @Param
 * @return
**/
@Mapper
public interface QwExcelApiMapper extends BaseMapper<EkpInvoiceInfo> {
	@Select("select \n" +
			"invoiceNo as '发票号',\n" +
			"contractNo as '合同号',\n" +
			"invoiceFee as '开票金额',\n" +
			"invoiceDate as '开票时间',\n" +
			"invoiceMonth as '开票月份',\n" +
			"saleName as '购买名称',\n" +
			"invoiceStatus as '发票状态',\n" +
			"invoiceRedReversal as '红冲状态',\n" +
			"concatInfo as '发票号&购买方名称&开票月份组合'\n" +
			"FROM  view_invoice_info")
	List<Map<String, Object>> selectInvoiceInfoAsMap();
	@Select("select \n" +
			"contractNo as '合同号',\n" +
			"contractName as '合同名称',\n" +
			"customerName as '客户名称',\n" +
			"customerNo as '客户编码',\n" +
			"division as '事业部',\n" +
			"newLine as '事业部条线',\n" +
			"incomeBelong as '业务收入归属部门',\n" +
			"contractStatus as '合同状态'\n" +
			"FROM  view_contract_info")
	List<Map<String, Object>> selectContractInfoAsMap();

	/**
	 * 带参数的查询
	 * @param startDate 查询区间开始时间
	 * @param endDate 查询区间结束时间
	 * @return List<Map<String, Object>>
	 */
	List<Map<String, Object>> selectInvoiceList(@Param("startDate") String startDate,@Param("endDate") String endDate);

	/**
	 * 查询合同信息列表
	 * @return List<Map<String, Object>>
	 */
	List<Map<String, Object>> selectContractList(@Param("limitStart") int limitStart,@Param("limitEnd") int limitEnd);

	/**
	 * 查询合同信息列表
	 * @return List<Map<String, Object>>
	 */
	int selectContractListCount();
}
