package com.yifu.cloud.plus.v1.ekp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.icbc.api.response.JftApiPayrollQueryDetailResponseV1;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSocialInfo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankAttaReturnVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 聚富通代发工资相关
 *
 * @author huyc
 * @date 2024-05-24 10:55:24
 */
public interface IcbcTransactionFlowIssueService extends IService<EkpSocialInfo> {

	/**
	 * @Description: 代发任务确认提交
	 * @Author: huyc
	 * @Date: 2024-11-12
	 * @return: R
	 **/
	R<String> submitIcbcTransactionFlow(String totalAmt, String totalCount, String wxNo
			, String url, String mdCode);

	/**
	 * @Description: 代发任务批次明细查询
	 * @Author: huyc
	 * @Date: 2024-11-12
	 * @return: R
	 **/
	JftApiPayrollQueryDetailResponseV1 selectIcbcTransactionFlowInfo(String wxNo, String startId, String endId);

	R asyncNotice(HttpServletRequest request) throws Exception;

	/**
	 * @Description: 根据银行卡号查询银行信息
	 * @Author: huyc
	 * @Date: 2024-11-12
	 * @return: R
	 **/
	R querybankinfo();

	/**
	 * @param fdId 主键ID
	 * @param type 类型 1：主表附件；2：明细表附件
	 * @Description: 下载银企付款
	 * @Author: hgw
	 * @Date: 2024/11/18 10:18
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.ekp.entity.EkpBankAtta>
	 **/
	R<EkpBankAttaReturnVo> getIssueFileByFdId(String fdId, String type);

	/**
	 * @param fdId 主键ID
	 * @param type 类型 1：主表附件；2：明细表附件
	 * @Description: 发放银企付款
	 * @Author: hgw
	 * @Date: 2024/11/22 11:32
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> submitBankTask(String fdId, String type, String submitUser);

	// 验证下载文件的正确性
	void exportAll(HttpServletResponse response);

	/**
	 * @Description: 每小时获取银企付款结果
	 * @Author: hgw
	 * @Date: 2024/11/22 16:56
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> doGetEkpBankStatus();

	R getPdfFile() throws IOException;

}
