package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.yifu.cloud.plus.v1.yifu.insurances.entity.TBusinessOperate;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_business_operate(业务操作记录表)】的数据库操作Service
 * @date 2022-12-08 10:20:16
 */
public interface TBusinessOperateService extends IService<TBusinessOperate> {
	/**
	 * 保存修改记录
	 *
	 * @author licancan
	 * @param businessId 业务表主键
	 * @param oldInfo 老的实体类
	 * @param newInfo 新的实体类
	 * @param remark 备注
	 * @return {@link TBusinessOperate}
	 */
	<T> TBusinessOperate saveModificationRecord(String businessId, T oldInfo, T newInfo, String remark);

	/**
	 * 根据业务主键获取操作记录
	 *
	 * @author licancan
	 * @param businessId
	 * @return {@link List<TBusinessOperate>}
	 */
	List<TBusinessOperate> getOperateListByBusinessId(String businessId);
}
