/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 个税申报手动刷新限制表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_statistics_tax_salary_rule")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "个税申报手动刷新限制表")
public class TStatisticsTaxSalaryRule extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 结算月
	 */
	@ExcelAttribute(name = "结算月", isNotEmpty = true, errorInfo = "结算月不能为空", maxLength = 6)
	@NotBlank(message = "结算月不能为空")
	@Length(max = 6, message = "结算月不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settleMonth;
	/**
	 * 一天可刷新次数，默认10，调小后不可手动刷新
	 */
	@ExcelAttribute(name = "一天可刷新次数，默认10，调小后不可手动刷新")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("一天可刷新次数，默认10，调小后不可手动刷新")
	private Integer canRefreshNums;
	/**
	 * 年月日
	 */
	@ExcelAttribute(name = "年月日", isNotEmpty = true, errorInfo = "年月日不能为空", maxLength = 8)
	@NotBlank(message = "年月日不能为空")
	@Length(max = 8, message = "年月日不能超过8个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年月日")
	private String yearMonthDay;

}
