package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/7/18
 * @Description 派单新增档案
 * @Version 1.0
 */
@Data
public class DispatchEmpVo implements Serializable {

	/*******************对应项目编码档案&项目档案相关信息*************************/
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工主码")
	private String empCode;
	/**
	 * 员工项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工项目编码")
	private String empNo;


	@Schema(description = "员工类型")
	@ExcelAttribute(name = "员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工类型")
	private String empNatrue;

	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;
	/**
	 * 身份证号码
	 */
	@Schema(description = "身份证号码")
	@NotNull(message = "身份证号码不可为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
	private String empIdcard;
	/**
	 * 民族
	 */
	@Schema(description = "民族")
	private String empNational;

	/**
	 * 手机号码
	 */
	@Schema(description = "手机号码")
	private String empPhone;
	/**
	 * 身份证-省
	 */
	@Schema(description = "身份证-省")
	private Integer idProvince;

	/**
	 * 身份证-市
	 */
	@Schema(description = "身份证-市")
	private Integer idCity;

	/**
	 * 身份证-县
	 */
	@Schema(description = "身份证-县")
	private Integer idTown;
	/**
	 * 户口性质
	 */
	@Schema(description = "户口性质")
	private String empRegisType;

	/**
	 * 档案-省
	 */
	@Schema(description = "档案-省")
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@Schema(description = "档案-市")
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@Schema(description = "档案-县")
	private Integer fileTown;

	/**
	 * 最高学历（字典值）
	 */
	@Schema(description = "最高学历（字典值）")
	private String hignEducation;
	/**
	 * 档案状态（0正常；1已减档）
	 */
	@Schema(description = "档案状态（0正常；1已减档）")
	private Integer fileStatus;
	// 以下是项目档案信息
	@TableField(exist = false)
	@Schema(description = "单位名称")
	private String unitName;

	@TableField(exist = false)
	@Schema(description = "单位编码")
	private String unitNo;

	@TableField(exist = false)
	@Schema(description = "项目id")
	private String deptId;

	@TableField(exist = false)
	@Schema(description = "项目名称")
	private String deptName;

	@TableField(exist = false)
	@Schema(description = "项目编码")
	private String deptNo;

	@TableField(exist = false)
	@Schema(description = "就职岗位")
	private String post;
	/*******************对应项目编码合同相关信息*************************/
	/**
	 * 合同类型
	 */
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;
	/**
	 * 签订期限
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;
	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", needExport = true)
	@Schema(description = "合同起始时间", name = "contractStart")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", needExport = true)
	@Schema(description = "合同到期时间", name = "contractEnd")
	private Date contractEnd;
	/**
	 * 合同年限
	 */
	@ExcelAttribute(name = "合同年限", errorInfo = "合同年限不能为空")
	@Schema(description = "合同年限", name = "contractTerm")
	private String contractTerm;

	/**
	 * 合同ID
	 */
	@ExcelAttribute(name = "合同ID")
	@Schema(description = "合同ID")
	private String contractId;

	/**
	 * 业务细分
	 */
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分（存lable）", name = "contractName")
	private String contractSubName;

	/**
	 * 项目状态（0正常；1已减项）
	 */
	@Schema(description ="项目状态（0正常；1已减项）")
	private Integer projectStatus;

	/**
	 * 通信地址
	 */
	private String contactAddress;


	/**
	 * 试用期（单位月）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="试用期")
	private String tryPeriod;

	@ExcelProperty(value ="学校")
	private String school;

}
