/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工资报账主表（工资条）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_salary_account")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "工资报账主表（工资条）")
public class TSalaryAccount extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 项目name
	 */
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目name不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目no
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目no不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;

	/**
	 * 客户ID
	 */
	@ExcelAttribute(name = "客户ID", isNotEmpty = true, errorInfo = "客户ID不能为空", maxLength = 32)
	@NotBlank(message = "客户ID不能为空")
	@Length(max = 32, message = "客户ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户ID")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称不能为空", maxLength = 50)
	@NotBlank(message = "客户名称不能为空")
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;

	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;
	/**
	 * 工资表ID
	 */
	@ExcelAttribute(name = "工资表ID", isNotEmpty = true, errorInfo = "工资表ID不能为空", maxLength = 32)
	@NotBlank(message = "工资表ID不能为空")
	@Length(max = 32, message = "工资表ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资表ID")
	private String salaryFormId;

	/**
	 * 员工 ID
	 */
	@ExcelAttribute(name = "员工 ID", maxLength = 32)
	@Length(max = 32, message = "员工 ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工 ID")
	private String empId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 手机号
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	@Length(max = 11, message = "手机号码不能超过11个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行卡号")
	private String bankNo;
	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行总行")
	private String bankName;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行省")
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市", isArea = true, parentField = "bankProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行市")
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行支行")
	private String bankSubName;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", isNotEmpty = true, errorInfo = "项目id不能为空", maxLength = 32)
	@NotBlank(message = "项目id不能为空")
	@Length(max = 32, message = "项目id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;


	/**
	 * 工资发放方式（0现金/1银行）/2线下
	 */
	@ExcelAttribute(name = "工资发放方式（0现金/1银行）/2线下", isNotEmpty = true, errorInfo = "工资发放方式（0现金/1银行）/2线下不能为空", maxLength = 1)
	@NotBlank(message = "工资发放方式（0现金/1银行）/2线下不能为空")
	@Length(max = 1, message = "工资发放方式（0现金/1银行）/2线下不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资发放方式（0现金/1银行）/2线下")
	private String salaryStyle;
	/**
	 * 工资发放时间（0立即发、1暂停发）
	 */
	@ExcelAttribute(name = "工资发放时间（0立即发、1暂停发）", isNotEmpty = true, errorInfo = "工资发放时间（0立即发、1暂停发）不能为空", maxLength = 1)
	@NotBlank(message = "工资发放时间（0立即发、1暂停发）不能为空")
	@Length(max = 1, message = "工资发放时间（0立即发、1暂停发）不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资发放时间（0立即发、1暂停发）")
	private String salaryGiveTime;
	/**
	 * 发放状态 0: 未发放 1: 发放成功 2:发放失败
	 */
	@ExcelAttribute(name = "发放状态 0: 未发放 1: 发放成功 2:发放失败", maxLength = 1)
	@Length(max = 1, message = "发放状态 0: 未发放 1: 发放成功 2:发放失败不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发放状态 0: 未发放 1: 发放成功 2:发放失败")
	private String distributionFlag;
	/**
	 * 社保扣缴月份
	 */
	@ExcelAttribute(name = "社保扣缴月份", maxLength = 20)
	@Length(max = 20, message = "社保扣缴月份不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保扣缴月份")
	private String deduSocialMonth;
	/**
	 * 公积金扣缴月份
	 */
	@ExcelAttribute(name = "公积金扣缴月份", maxLength = 20)
	@Length(max = 20, message = "公积金扣缴月份不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金扣缴月份")
	private String deduProvidentMonth;
	/**
	 * 表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@ExcelAttribute(name = "表单类型", readConverterExp = "0=薪资,1=绩效,2=其他,3=劳务费,4=稿酬")
	@NotBlank(message = "表单类型不能为空")
	@Length(max = 32, message = "表单类型不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("表单类型")
	private String formType;
	/**
	 * 薪酬月份
	 */
	@ExcelAttribute(name = "薪酬月份", isNotEmpty = true, errorInfo = "薪酬月份不能为空", maxLength = 6)
	@NotBlank(message = "薪酬月份不能为空")
	@Length(max = 6, message = "薪酬月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪酬月份")
	private String salaryMonth;
	/**
	 * 结算月
	 */
	@ExcelAttribute(name = "结算月", isNotEmpty = true, errorInfo = "结算月不能为空", maxLength = 20)
	@NotBlank(message = "结算月不能为空")
	@Length(max = 20, message = "结算月不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settlementMonth;
	/**
	 * 是否删除0：正常；1：已删除
	 */
	@ExcelAttribute(name = "是否删除0：正常；1：已删除", isNotEmpty = true, errorInfo = "是否删除0：正常；1：已删除不能为空")
	@NotBlank(message = "是否删除0：正常；1：已删除不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否删除0：正常；1：已删除")
	private Integer deleteFlag;
	/**
	 * 社保优先级0：生成月；1：缴纳月
	 */
	@ExcelAttribute(name = "社保优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "社保优先级0：生成月；1：缴纳月不能为空", maxLength = 1)
	@NotBlank(message = "社保优先级0：生成月；1：缴纳月不能为空")
	@Length(max = 1, message = "社保优先级0：生成月；1：缴纳月不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保优先级0：生成月；1：缴纳月")
	private String socialPriority;
	/**
	 * 公积金优先级0：生成月；1：缴纳月
	 */
	@ExcelAttribute(name = "公积金优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "公积金优先级0：生成月；1：缴纳月不能为空", maxLength = 1)
	@NotBlank(message = "公积金优先级0：生成月；1：缴纳月不能为空")
	@Length(max = 1, message = "公积金优先级0：生成月；1：缴纳月不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金优先级0：生成月；1：缴纳月")
	private String fundPriority;
	/**
	 * 社保类型0：缴费库；1：预估库
	 */
	@ExcelAttribute(name = "社保类型0：缴费库；1：预估库")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保类型0：缴费库；1：预估库")
	private String socialType;
	/**
	 * 公积金类型0：缴费库；1：预估库
	 */
	@ExcelAttribute(name = "公积金类型0：缴费库；1：预估库")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金类型0：缴费库；1：预估库")
	private String fundType;
	/**
	 * 年终奖扣税方案0：合并；1：单独
	 */
	@ExcelAttribute(name = "年终奖扣税方案0：合并；1：单独", maxLength = 1)
	@Length(max = 1, message = "年终奖扣税方案0：合并；1：单独不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖扣税方案0：合并；1：单独")
	private String annualBonusType;
	/**
	 * 计税月份
	 */
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Length(max = 6, message = "计税月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份")
	private String taxMonth;
	/**
	 * 是否扣除社保 0:否,1:是
	 */
	@ExcelAttribute(name = "是否扣除社保 0:否,1:是", maxLength = 1)
	@Length(max = 1, message = "是否扣除社保 0:否,1:是不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否扣除社保 0:否,1:是")
	private String isDeductSocial;
	/**
	 * 是否扣除公积金 0:否,1:是
	 */
	@ExcelAttribute(name = "是否扣除公积金 0:否,1:是", maxLength = 1)
	@Length(max = 1, message = "是否扣除公积金 0:否,1:是不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否扣除公积金 0:否,1:是")
	private String isDeductFund;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	private Integer town;

	/**
	 * 是否自有员工0：否；1：是自有员工
	 */
	@ExcelAttribute(name = "是否自有员工0：否；1：是自有员工")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否自有员工0：否；1：是自有员工")
	private Integer ownFlag;

	@Schema(description = "劳务费、稿酬是否含有发薪0：否；1：是")
	@ExcelAttribute(name = "劳务费、稿酬是否含有发薪")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("劳务费、稿酬是否含有发薪")
	private Integer haveSalaryFlag;

	@Schema(description = "是否含有特殊金额0：否；1：是")
	@ExcelAttribute(name = "是否含有特殊金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含有特殊金额")
	private Integer haveSpecialFlag;

	/**
	 * 本月是否重复金额0：否；1：是重复导入的
	 */
	@ExcelAttribute(name = "本月是否重复金额0：否；1：是重复导入的")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本月是否重复金额0：否；1：是重复导入的")
	private Integer isRepeat;

	/**
	 * 是否个人承担部分税费
	 * 公司承担全部税费0
	 * 个人承担部分税费1
	 * 个人承担全部税费2
	 */
	@ExcelAttribute(name = "是否个人承担部分税费", maxLength = 8, readConverterExp = "0=公司承担全部税费,1=个人承担部分税费,2=个人承担全部税费")
	@Length(max = 1, message = "是否个人承担部分税费不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否个人承担部分税费")
	private String isPersonTax;
	/**
	 * 应发薪酬（劳务费、稿酬）
	 */
	@ExcelAttribute(name = "应发薪酬")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发薪酬")
	private BigDecimal relaySalary;
	/**
	 * 实发（个人实收）
	 */
	@ExcelAttribute(name = "实发（个人实收）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人实发合计")
	private BigDecimal actualSalary;
	/**
	 * 个税金额（个人承担）
	 */
	@ExcelAttribute(name = "个税金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税金额")
	private BigDecimal salaryTax;
	/**
	 * 公司应发
	 */
	@ExcelAttribute(name = "公司应发")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公司应发")
	private BigDecimal relaySalaryUnit;
	/**
	 * 个税-单位承担
	 */
	@ExcelAttribute(name = "个税-单位承担")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税-单位承担")
	private BigDecimal salaryTaxUnit;

	@ExcelAttribute(name = "发送状态：0未发送，1已发送")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送状态：0未发送，1已发送")
	private String sendStatus;

	@ExcelAttribute(name = "发送月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送月份")
	private String sendMonth;

	@ExcelAttribute(name = "发送时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送时间")
	private Date sendTime;

	@ExcelAttribute(name = "发送人id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送人id")
	private String sendUser;

	@ExcelAttribute(name = "发送人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送人姓名")
	private String sendUserName;

	@ExcelAttribute(name = "发送返回的EKPID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送返回的EKPID")
	private String ekpId;

	@TableField(exist = false)
	private List<TSalaryAccountItem> saiList = new ArrayList<>();  //工资组成部分明细
	/**
	 * 订单ID
	 */
	@ExcelAttribute(name = "订单ID")
	@Schema(description = "订单ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("订单ID" )
	private String orderId;

	@ExcelAttribute(name = "单位社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保")
	private BigDecimal unitSocial;

	@ExcelAttribute(name = "个人社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保")
	private BigDecimal personSocial;

	@ExcelAttribute(name = "单位公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金")
	private BigDecimal unitFund;

	@ExcelAttribute(name = "个人公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金")
	private BigDecimal personFund;

	@ExcelAttribute(name = "减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减除费用")
	private BigDecimal costReduction;

	// 累计子女教育	累计继续教育	累计住房贷款利息	累计住房租金	累计赡养老人	累计3岁以下婴幼儿照护
	@ExcelAttribute(name = "累计子女教育", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计子女教育")
	private BigDecimal sumChildEduMoney;

	@ExcelAttribute(name = "累计继续教育", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计继续教育")
	private BigDecimal sumContinuingEducationMoney;

	@ExcelAttribute(name = "累计住房贷款利息", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计住房贷款利息")
	private BigDecimal sumHousingLoanMoney;

	@ExcelAttribute(name = "累计住房租金", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计住房租金")
	private BigDecimal sumHousingRentMoney;

	@ExcelAttribute(name = "累计赡养老人", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计赡养老人")
	private BigDecimal sumSupportElderlyMoney;

	@ExcelAttribute(name = "累计3岁以下婴幼儿照护", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;

	@ExcelAttribute(name = "累计个人养老金", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;

	@ExcelAttribute(name = "年终奖单独扣税税费", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "年终奖单独扣税税费")
	private BigDecimal annualBonusTax;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 已冻结
	 */
	@Schema(description = "收入信息结算状态")
	private String incomeSettleFlag;

	/**
	 * 收入信息收款状态 0 已收 1 未收 2 垫付
	 */
	@Schema(description = "收入信息收款状态")
	private String incomeCollectFlag;

	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算
	 */
	@Schema(description = "支出信息结算状态")
	private String paySettleFlag;

	/**
	 * 收入信息结算状态 0 已付 1 未付
	 */
	@Schema(description = "支出信息付款状态")
	private String payCollectFlag;

	/**
	 * 是否差额单 默认0否； 1是
	 */
	@Schema(description = "是否差额单")
	private String isDiff;

	/**
	 * 工资月份-起
	 */
	@TableField(exist = false)
	private String salaryMonthStart;
	/**
	 * 工资月份-止
	 */
	@TableField(exist = false)
	private String salaryMonthEnd;

	/**
	 * 结算月份-起
	 */
	@TableField(exist = false)
	private String settleMonthStart;
	/**
	 * 结算月份-止
	 */
	@TableField(exist = false)
	private String settleMonthEnd;

	@ExcelProperty(value = "导入行号")
	private Integer rowIndex;

	// 额外给前端导出使用的
	@TableField(exist = false)
	@ExcelProperty("企业（职业）年金")
	private String enterpriseAnnuity;
	@TableField(exist = false)
	@ExcelProperty("个人代扣金额")
	private String pdeductionMoney;
}
