/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 个税申报手动刷新限制表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TStatisticsTaxSalaryRuleVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 结算月
	 */
	@NotBlank(message = "结算月 不能为空")
	@Length(max = 6, message = "结算月 不能超过6 个字符")
	@ExcelAttribute(name = "结算月", isNotEmpty = true, errorInfo = "结算月 不能为空", maxLength = 6)
	@Schema(description = "结算月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settleMonth;
	/**
	 * 一天可刷新次数，默认10，调小后不可手动刷新
	 */
	@ExcelAttribute(name = "一天可刷新次数，默认10，调小后不可手动刷新")
	@Schema(description = "一天可刷新次数，默认10，调小后不可手动刷新")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("一天可刷新次数，默认10，调小后不可手动刷新")
	private Integer canRefreshNums;
	/**
	 * 年月日
	 */
	@NotBlank(message = "年月日 不能为空")
	@Length(max = 8, message = "年月日 不能超过8 个字符")
	@ExcelAttribute(name = "年月日", isNotEmpty = true, errorInfo = "年月日 不能为空", maxLength = 8)
	@Schema(description = "年月日")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年月日")
	private String yearMonthDay;

}
