package com.yifu.cloud.plus.v1.yifu.common.core.util;

import com.cloopen.rest.sdk.BodyType;
import com.cloopen.rest.sdk.CCPRestSmsSDK;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Set;

/**
 * 容联云短信实现工具类，可以单个发送短信，批量发送短信
 *
 * @author fxj
 * @version 1.0
 * @since 2025/10/21
 */
@Component
@Data
@Slf4j
public class RlySmsUtil {
    
    private CCPRestSmsSDK sdk;
    
    // 服务器地址
    private String serverIp = "app.cloopen.com";
    
    // 服务器端口
    private String serverPort = "8883";
    
    // 主账号
    private  String accountSId = "8a48b5515388ec150153acb1cd5b3899";
    
    // 主账号令牌
    private String accountToken = "5487aa42bb574b47aca1c785b4e7c018";
    
    // 应用ID
    private String appId = "2c94811c9787a27f019854cd1b532b7e";

    /**
     * 初始化SDK
     *
     * @param accountSId   主账号
     * @param accountToken 主账号令牌
     * @param appId        应用ID
     */
    public void init(String accountSId, String accountToken, String appId) {
		if (null == sdk){
			this.accountSId = accountSId;
			this.accountToken = accountToken;
			this.appId = appId;

			sdk = new CCPRestSmsSDK();
			sdk.init(serverIp, serverPort);
			sdk.setAccount(accountSId, accountToken);
			sdk.setAppId(appId);
			sdk.setBodyType(BodyType.Type_JSON);
		}
    }
    
    /**
     * 单个发送短信
     *
     * @param phoneNumber  手机号码
     * @param templateId   模板ID
     * @param datas        短信参数
     * @return 发送结果 true-成功 false-失败
     */
    public  boolean sendSingleSms(String phoneNumber, String templateId, String[] datas) {
		init(accountSId, accountToken, appId);
        HashMap<String, Object> result = sdk.sendTemplateSMS(phoneNumber, templateId, datas);
        
        if ("000000".equals(result.get("statusCode"))) {
            // 正常返回输出data包体信息
            HashMap<String, Object> data = (HashMap<String, Object>) result.get("data");
            Set<String> keySet = data.keySet();
            for (String key : keySet) {
                Object object = data.get(key);
            }
            return true;
        } else {
            // 异常返回输出错误码和错误信息
			log.error("错误码=" + result.get("statusCode") + " 错误信息= " + result.get("statusMsg"));
            return false;
        }
    }
    
    /**
     * 批量发送短信
     *
     * @param phoneNumbers 手机号码数组
     * @param templateId   模板ID
     * @param datas        短信参数
     * @return 发送结果 true-成功 false-失败
     */
    public HashMap<String, Object> sendBatchSms(String[] phoneNumbers, String templateId, String[][] datas) {
		init(accountSId, accountToken, appId);
        // 将手机号数组转换为逗号分隔的字符串
        StringBuilder phoneNumbersStr = new StringBuilder();
        for (int i = 0; i < phoneNumbers.length; i++) {
            if (i > 0) {
                phoneNumbersStr.append(",");
            }
            phoneNumbersStr.append(phoneNumbers[i]);
        }
        
        // 容联云短信SDK只支持单个模板参数数组，不直接支持多个不同参数
        // 这里假设所有手机号使用相同参数发送
        // 如果需要不同的参数，需要多次调用单个发送方法
        String[] singleData = datas.length > 0 ? datas[0] : new String[0];
        
        HashMap<String, Object> result = sdk.sendTemplateSMS(phoneNumbersStr.toString(), templateId, singleData);

		return result;
    }
}