
package com.yifu.cloud.plus.v1.ekp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 款项认领差额费导入
 *
 * @author huyc
 * @date 2024-07-04 14:54:40
 */
@Data
@ColumnWidth(30)
public class ClaimInfotVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 项目编码
     */
	@NotNull(message = "项目编码不能为空")
	@ExcelAttribute(name = "项目编码",isNotEmpty = true, errorInfo = "项目编码不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目编码")
    private String deptNo;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目名称")
	private String deptName;

    /**
     * 调整金额
     */
	@NotNull(message = "调整金额不能为空")
	@ExcelAttribute(name = "调整金额",isNotEmpty = true, errorInfo = "调整金额不能为空", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="调整金额")
    private BigDecimal money;
}
