package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户数据权限表
 *
 * @author pwang
 * @date 2019-07-19 16:22:22
 */
@Data
@TableName("t_cutsomer_data_permisson")
@Schema(description = "客户数据权限表")
public class TCutsomerDataPermisson implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键", name = "id")
    private String id;

    @Length(max = 1, message = "状态不能超过1个字符")
    @ExcelAttribute(name = "状态", maxLength = 1)
    @Schema(description = "状态0启用1禁用")
    private String status;

    @Length(max = 32, message = "备注不能超过32个字符")
    @ExcelAttribute(name = "备注", maxLength = 32)
    @Schema(description = "备注")
    private String remark;

	@Length(max = 32, message = "项目id不能超过32个字符")
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Schema(description = "项目id")
	private String settleDomainId;

	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	private String settleDomainName;

	@Length(max = 32, message = "项目编码不能超过32个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 32)
	@Schema(description = "项目编码")
	private String settleDomainNo;

	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	@Schema(description = "创建人")
	@TableField(fill = FieldFill.INSERT)
	@ExcelIgnore
	private String createBy;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

    @NotBlank(message = "被授权人不能为空")
    @Length(max = 32, message = "被授权人不能超过32个字符")
    @ExcelAttribute(name = "被授权人", isNotEmpty = true, errorInfo = "被授权人不能为空", maxLength = 32)
    @Schema(description = "被授权人")
    private String userId;

    @ExcelAttribute(name = "登录名", maxLength = 50)
    @Schema(description = "登录名")
    private String userLoginName;

	@ExcelAttribute(name = "用户名称", maxLength = 50)
    @Schema(description = "用户名称（汉字）")
    private String userNickName;

	@ExcelAttribute(name = "所在部门", maxLength = 50)
    @Schema(description = "所在部门")
    private String userDeptName;

	@ExcelIgnore
    @Schema(description = "授权来源0ekp,1mvp,2mvp复制")
    private String type;

	@TableField(exist = false)
	@ExcelIgnore
    @Schema(description = "导出选中的行id数组")
    private List<String> idList;
}
