package com.yifu.cloud.plus.v1.yifu.archives.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

/**
 * @auther wangan
 * @date 2021/1/18
 * 法大大基本配置
 */
@RefreshScope
@ConfigurationProperties(prefix = "fdd")
@Data
public class FddConfigProperties {

	/**
	 * @Author: wangan
	 * @Date: 2021/1/18
	 * @Description: 法大大分配的接入id
	 **/
	private String appId;

	/**
	 * @Description: 法大大分配的appid对应的key
	 **/
	private String appKey;

	/**
	 * @Description: 指定环境请求url
	 **/
	private String serverUrl;

	/**
	 * http连接超时时间
	 */
	private int connectTimeout;

	/**
	 * http读超时时间
	 */
	private int readTimeout;


	/**
	 * 系统地址
	 */
	private String hrmsUrl;


	/**
	 * 异步通知地址
	 */
	private String notifyUrl="/fdd/notifyUrl";

	/**
	 * 个人实名回调地址
	 */
	private String personRedirectUrl="/fdd/personRedirectUrl";

	/**
	 * 邀请员工回调地址
	 */
	private String addEmployeeRedirectUrl="/fdd/addEmployeeRedirectUrl";
}
