/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractTemplate;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddContractTemplateService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.io.IOException;


/**
 * 法大大员工合同模板
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddcontracttemplate" )
@Tag(name = "法大大员工合同模板管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddContractTemplateController {

    private final FddContractTemplateService fddContractTemplateService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param fddContractTemplate 法大大员工合同模板
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    public R getFddContractTemplatePage(Page page, FddContractTemplate fddContractTemplate) throws ApiException {
        return R.ok(fddContractTemplateService.getFddContractTemplatePage(page, fddContractTemplate));
    }

    /**
     * 通过id查询法大大员工合同模板
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_fddcontracttemplate_get')")
    @GetMapping("/{id}" )
    public R getById(@PathVariable("id" ) String id) {
        return R.ok(fddContractTemplateService.getById(id));
    }

    /**
     * 修改法大大员工合同模板
     * @param fddContractTemplate 法大大员工合同模板
     * @return R
     */
    @Operation(summary = "修改法大大员工合同模板", description = "修改法大大员工合同模板：hasPermission('demo_fddcontracttemplate_edit')")
    @SysLog("修改法大大员工合同模板" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_fddcontracttemplate_edit')" )
    public R updateById(@RequestBody FddContractTemplate fddContractTemplate) {
        return fddContractTemplateService.changeInfo(fddContractTemplate);
    }

    /**
     * 通过id删除法大大员工合同模板
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除法大大员工合同模板", description = "通过id删除法大大员工合同模板：hasPermission('demo_fddcontracttemplate_del')")
    @SysLog("通过id删除法大大员工合同模板" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_fddcontracttemplate_del')" )
    public R removeById(@PathVariable String id) {
        return R.ok(fddContractTemplateService.removeById(id));
    }

	/**
	 * 新增合同模板
	 * @param fddContractTemplate
	 * @return R
	 */
	@Operation(summary = "新增合同模板", description = "新增合同模板")
	@SysLog("新增合同模板" )
	@PostMapping
	public R save(@Valid @RequestBody FddContractTemplate fddContractTemplate) {
		return fddContractTemplateService.saveInfo(fddContractTemplate);
	}

	/**
	 * @param file
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @Description: 法大大模板上传
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "法大大模板上传", description = "法大大模板上传")
	@SysLog("法大大模板上传" )
	@PostMapping("/upload")
	public R<String> upload(@RequestBody MultipartFile file, @RequestParam String id) throws ApiException, IOException {
		return fddContractTemplateService.upload(file, id);
	}


	/**
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @Description: 模板文件删除
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "模板文件删除", description = "模板文件删除")
	@SysLog("模板文件删除" )
	@PostMapping("/del")
	public R<String> delCompanyTemplateFile(@RequestParam String id) throws ApiException {
		return fddContractTemplateService.delCompanyTemplateFile(id);
	}


	/**
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @Description: 获取模板维护地址
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "获取模板维护地址", description = "获取模板维护地址")
	@SysLog("获取模板维护地址" )
	@GetMapping("/getTemplateMainUrl")
	public R<String> getTemplateMainUrl(@RequestParam String id) throws ApiException {
		return fddContractTemplateService.getTemplateMainUrl(id);
	}


	/**
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @Description: 获取模板文件预览地址
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "获取模板文件预览地址", description = "获取模板文件预览地址")
	@SysLog("获取模板文件预览地址")
	@GetMapping("/getCompanyTemplatePreviewUrl")
	public R<String> getCompanyTemplatePreviewUrl(@RequestParam String id) throws ApiException {
		return fddContractTemplateService.getCompanyTemplatePreviewUrl(id);
	}
}
