/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCustomerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import java.util.List;

/**
 * 项目表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
public interface TSettleDomainService extends IService<TSettleDomain> {

	/**
	 * @param page
	 * @param tSettleDomain
	 * @Description: 分页列表
	 * @Author: hgw
	 * @Date: 2022/12/1 14:22
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain>
	 **/
	IPage<TSettleDomain> getPage(Page<TSettleDomain> page, TSettleDomain tSettleDomain);

	/**
	 * @param page
	 * @param tSettleDomain
	 * @Description: 分页列表
	 * @Author: hgw
	 * @Date: 2022/12/1 14:22
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain>
	 **/
	IPage<SecondBelongVo> getTwoBlongPage(Page<TSettleDomain> page, TSettleDomain tSettleDomain);

	/**
	 * @param tSettleDomain
	 * @Description: 全部list
	 * @Author: hgw
	 * @Date: 2022/12/1 14:22
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain>
	 **/
	List<TSettleDomain> getList(TSettleDomain tSettleDomain);

	/**
	 * @param page
	 * @param idNameNoVo
	 * @Description: 获取客户单位单位
	 * @Author: hgw
	 * @Date: 2022/10/21 10:01
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.vo.IdNameNoVo>
	 **/
	IPage<IdNameNoVo> getUnitPage(Page<IdNameNoVo> page, IdNameNoVo idNameNoVo);

	/**
	 * 清除userId的项目权限缓存
	 *
	 * @param user
	 * @return
	 * @Author fxj
	 * @Date 2022-07-11 16:57
	 **/
	void removeSettleCache(YifuUser user, List<String> userId);

	List<String> getSettleDomainIdsByUserId(String id);

	List<String> getAllDeptByCustomerLoginName(String userLoginName);

	/**
	 * 获取用户所拥有的项目编码
	 */
	List<String> getSettleDomainNosByUserId(String id);

	SetInfoVo getSetInfoByCodes(List<String> codes);

	TSettleDomainListVo getSettleInfoByCodes(List<String> codes);

	/**
	 * 通过id获取项目及单位部分信息
	 * @param
	 * @return
	 * @Author fxj
	 * @Date 2019-12-24
	 **/
	TSettleDomainSelectVo selectSettleDomainSelectVosById(TSettleDomainSelectVo settleDomainSelectVo);


	TSettleDomainSelectVo getSettleDomainVoById(String id);

	/**
	 * 获取所有客户单位的项目信息
	 * @param
	 * @return
	 * @Author fxj
	 * @Date 2019-12-24
	 **/
	List<TSettleDomainSelectVo> selectAllSettleDomainSelectVos();

	R updateProjectInfo(List<TSettleDomainEkpVo> list);

	R updateProjectStopStatus(List<TSettleDomainUpdVo> list);

	List<TSettleDomain> getOwnSettleDomainNoPage(String toString, String settleName);

	R<IPage<TSettleDomainVo>> getOwnSettleDomain(Page<TSettleDomainVo> page, String userId, String name);

	R<IPage<TCustomerInfo>> getTCustomerInfoPageForB(Page<TCustomerInfo> page, TCustomerInfo tCustomerInfo);

	R<IPage<TSettleDomainVo>> getTSettleDomainPageB(Page<TSettleDomainVo> page, TSettleDomainVo tSettleDomain);

	List<TCustomerInfo> getTCustomerInfoForB(List<String> customerList);

	R<IPage<CustomerOwnerSelectVo>> getCustomerOwnerPage(Page<CustomerOwnerSelectVo> page, String customerName, String userId);

	R<Boolean> updateProjectServerTeam(List<TSettleDomainUpServerTeamVo> list);

	R<Boolean> changeIssueStatus(ChangeIssueStatusVo changeIssueStatusVo);

	R<Boolean> updateProjectCsInfo(List<TDomainUpCsVo> list);
}
