package com.yifu.cloud.plus.v1.business.dto.vacation;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @description: 新增假期
 * @author: wangweiguo
 * @date: 2021/8/13
 */
@Getter
@Setter
@ToString
public class AddOrSaveVacationRuleDTO implements Serializable {
    /**
     * 主键
     */
	@Schema(description = "主键，更新时该值必传")
	private Integer id;

    /**
     * 假期类型 1年假
     */
    @NotBlank(message = "假期类型,不能为空")
	@Schema(description = "假期类型 1年假")
	private String type;

    /**
     * 是否自动发放假期时间 0否 1是
     */
	@Schema(description = "是否自动发放假期时间 0否 1是")
	@NotBlank(message = "是否自动发放假期时间,不能为空")
    private String vacationAutoInit;

    /**
     * 假期初始化时间
     */
	@Schema(description = "假期初始化时间")
	@NotNull(message = "假期初始化时间,不能为空")
    private LocalDate vacationInitDate;

    /**
     * 时间刻度 1按小时（和TIME_VALUE字段一起保证一天可以被不同单位数量的时间转换）
     */
	@Schema(description = "时间刻度 1按小时（和TIME_VALUE字段一起保证一天可以被不同单位数量的时间转换）")
	@NotBlank(message = "时间刻度,不能为空")
    private String timeScale;

    /**
     * 以时间刻度为单位的时间值（和TIME_SCALE字段一起保证一天可以被不同单位数量的时间转换）
     */
	@Schema(description = "以时间刻度为单位的时间值（和TIME_SCALE字段一起保证一天可以被不同单位数量的时间转换）")
	@NotNull(message = "时间值,不能为空")
    @Digits(integer = 5, fraction = 1, message = "整数不超过5位，小数不超过1位")
    private BigDecimal timeValue;
}
