package com.yifu.cloud.plus.v1.business.mapper.system;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarning;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * B端预警表
 *
 * @author hgw
 * @date 2021-08-20 17:39:51
 */
@Mapper
public interface TBusWarningMapper extends BaseMapper<TBusWarning> {
     /**
      * B端预警表简单分页查询
      *
      * @param tBusWarning B端预警表
      * @return
      */
     IPage<TBusWarning> getTBusWarningPage(Page<TBusWarning> page, @Param("tBusWarning") TBusWarning tBusWarning);

     /**
      * @param
      * @Description: 自动发送短信的list
      * @Author: hgw
      * @Date: 2021/8/24 11:41
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusWarning>
      **/
     List<TBusWarning> getListByAutoSend();

     /**
      * @param
      * @Description: 系统消息
      * @Author: hgw
      * @Date: 2021/8/25 12:53
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusWarning>
      **/
     List<TBusWarning> getListBySystem();

}
