package com.yifu.cloud.plus.v1.yifu.common.ldap.mapper;

import com.yifu.cloud.plus.v1.yifu.common.ldap.entity.PersonVo;
import org.springframework.ldap.core.AttributesMapper;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;

public class PersonAttributesMapper implements AttributesMapper<PersonVo> {

	@Override
	public PersonVo mapFromAttributes(Attributes attributes) throws NamingException {
		PersonVo personVo = new PersonVo();
		if (null != attributes.get("cn")) {
			personVo.setPersonName((String) attributes.get("cn").get());
		}
		if (null != attributes.get("uid")) {
			personVo.setUid((String) attributes.get("uid").get());
		}
		if (null != attributes.get("telephoneNumber")) {
			personVo.setTelephoneNumber((String) attributes.get("telephoneNumber").get());
		}
		if (null != attributes.get("mail")) {
			personVo.setEmail((String) attributes.get("mail").get());
		}else {
			personVo.setEmail("");
		}
		if (null != attributes.get("ou")) {
			personVo.setDeptName((String) attributes.get("ou").get());
		}
		if (null != attributes.get("x-init-role-ids")) {
			personVo.setRoleIds((String) attributes.get("x-init-role-ids").get());
		}
		return personVo;
	}
}
