/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 薪资工资条配置明细表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryStandardSetDetailVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * TSalaryStandardSet表的主键
	 */
	@NotBlank(message = "TSalaryStandardSet表的主键 不能为空")
	@Length(max = 32, message = "TSalaryStandardSet表的主键 不能超过32 个字符")
	@ExcelAttribute(name = "TSalaryStandardSet表的主键", isNotEmpty = true, errorInfo = "TSalaryStandardSet表的主键 不能为空", maxLength = 32)
	@Schema(description = "TSalaryStandardSet表的主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("TSalaryStandardSet表的主键")
	private String setId;
	/**
	 * cnName
	 */
	@NotBlank(message = "cnName 不能为空")
	@Length(max = 50, message = "cnName 不能超过50 个字符")
	@ExcelAttribute(name = "cnName", isNotEmpty = true, errorInfo = "cnName 不能为空", maxLength = 50)
	@Schema(description = "cnName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("cnName")
	private String cnName;
	/**
	 * orderLine
	 */
	@NotBlank(message = "orderLine 不能为空")
	@ExcelAttribute(name = "orderLine", isNotEmpty = true, errorInfo = "orderLine 不能为空")
	@Schema(description = "orderLine")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("orderLine")
	private Integer orderLine;

}
