/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ResultConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.redis.RedisDistributedLock;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAverageSalaryService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TAverageSalaryVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 前12月平均工资（MVP-TDC接口）
 *
 * @author hgw
 * @date 2023-6-19 16:27:44
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/taveragesalary")
@Tag(name = "前12月平均工资（MVP-TDC接口）")
public class TAverageSalaryController {

	private final TAverageSalaryService tAverageSalaryService;

	/**
	 * @Description: 定时任务-前12月平均工资
	 * @Author: hgw
	 * @Date: 2023-6-19 16:29:50
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Inner
	@Operation(description = "定时任务-前12月平均工资")
	@PostMapping("/inner/doCreateAverageSalary")
	public void doCreateAverageSalary() {
		tAverageSalaryService.createAverageSalary();
	}
	/**
	 * @Author fxj
	 * @Description 获取-前12月平均工资数据
	 * @Date 10:20 2023/6/20
	 * @Param
	 * @return
	**/
	@Operation(description = "获取-前12月平均工资数据")
	@GetMapping("/getAverageSalary")
	public R<List<TAverageSalaryVo>> getAverageSalary(String idNum) {
		// 获取redis分布式事务锁
		String key = CacheConstants.PAYMENT_DISPATCH_BATCH_ADD_IMPORT + CommonConstants.DOWN_LINE_STRING + "getAverageSalary";
		String requestId;
		try {
			requestId = RedisDistributedLock.getLock(key,"10");
		} catch (Exception e) {
			throw new RuntimeException(ResultConstants.NO_GETLOCK_DATA+CommonConstants.DOWN_LINE_STRING+e.getMessage());
		}
		try {
			if (Common.isNotNull(requestId)) {
				//主动释放锁
				return tAverageSalaryService.getAverageSalary(idNum);
			} else {
				return R.failed(ResultConstants.NO_GETLOCK_DATA);
			}
		}finally {
			//主动释放锁
			RedisDistributedLock.unlock(key, requestId);
		}

	}

}
