package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import com.yifu.cloud.plus.v1.yifu.salary.vo.THaveSalaryNoSocialExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.THaveSalaryNosocialHandleExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.THaveSalaryNosocialSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 有资没有社保(首页提醒定时任务）
 *
 * @author wangan
 * @date 2019-11-26 09:34:58
 */
@Mapper
public interface THaveSalaryNosocialMapper extends BaseMapper<THaveSalaryNosocial> {
  /**
    * 有资没有社保(首页提醒定时任务）简单分页查询
    * @param tHaveSalaryNosocial 有资没有社保(首页提醒定时任务）
    * @return
    */
  IPage<THaveSalaryNosocial> getTHaveSalaryNosocialPage(Page<THaveSalaryNosocial> page, @Param("tHaveSalaryNosocial") THaveSalaryNosocial tHaveSalaryNosocial, @Param("settleDomainVos") List<TSettleDomainSelectVo> settleDomainVos );


  IPage<THaveSalaryNosocial> getTHaveSalaryNosocialHandelPage(Page<THaveSalaryNosocial> page, @Param("tHaveSalaryNosocial") THaveSalaryNosocial tHaveSalaryNosocial );


  List<THaveSalaryNosocial> getByIdExport(String[] ids);

  List<THaveSalaryNosocial> getExport(@Param("tHaveSalaryNosocial") THaveSalaryNosocial vo,@Param("settleDomainVos") List<TSettleDomainSelectVo> settleDomainVos);


  List<THaveSalaryNosocialHandleExportVo> getByIdHandleExport(String[] ids);

  List<THaveSalaryNosocialHandleExportVo> getHandleExport(@Param("tHaveSalaryNosocial") THaveSalaryNosocial vo);


  List<THaveSalaryNosocial> getLastTHaveSalaryNosocial(@Param("lastOneMonth")String lastOneMonth,@Param("lastTwoMonth") String lastTwoMonth,@Param("lastThreeMonth") String lastThreeMonth);
	/**
	 * @Author fxj
	 * @Description  获取有工资无数据不分页数据
	 * @Date 16:57 2022/8/17
	 * @Param
	 * @return
	**/
    List<THaveSalaryNoSocialExportVo> noPageDiy(@Param("tHaveSalaryNosocial")THaveSalaryNosocialSearchVo searchVo,
												@Param("settleDomainIds")List<String> settleDomains,
												@Param("idsStr") List<String> idsStr,
												@Param("sql")String sql);
	/**
	 * @Author fxj
	 * @Description 获取有工资无数据不分页数据COUNT
	 * @Date 16:58 2022/8/17
	 * @Param
	 * @return
	**/
	int noPageCountDiy(@Param("tHaveSalaryNosocial")THaveSalaryNosocialSearchVo searchVo,
						@Param("settleDomainIds")List<String> settleDomains,
						@Param("idsStr") List<String> idsStr,
						@Param("sql")String sql);
}
