package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalary;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SysMessageSalarySearchVo;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;

/**
 * 最低工资提醒-每月更新一次
 *
 * @author hgw
 * @date 2019-11-21 17:18:10
 */
public interface SysMessageSalaryService extends IService<SysMessageSalary> {

     /**
      * 最低工资提醒-每月更新一次简单分页查询
      *
      * @param sysMessageSalary 最低工资提醒-每月更新一次
      * @return
      */
     IPage<SysMessageSalary> getSysMessageSalaryPage(Page<SysMessageSalary> page, SysMessageSalary sysMessageSalary);

     IPage<SysMessageSalary> getSysMessageSalaryHandlePage(Page<SysMessageSalary> page, SysMessageSalary sysMessageSalary);

     /**
      * @Author fxj
      * @Description 新增-普通工资
      * @Date 19:43 2022/8/17
     **/
     void insertSalaryBySettleMonth(@Param("settleMonth") String settleMonth);



     /**
      * @Author fxj
      * @Description 生成前，先删除老数据
      * @Date 19:42 2022/8/17
      * @Param settleMonth 结算月
      * @return
     **/
     void deleteAllBySettleMonth(String settleMonth);

    void listExport(HttpServletResponse response, SysMessageSalarySearchVo searchVo);

	R<String> feedback(Integer reasonType, String id, String feedBack);
}
