/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Data
public class TGzEmpInfoSearchVo extends TGzEmpInfo {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	@TableField(exist = false)
	private String ids;

	/**
	 * 查询使用:提交档案时间开始
	 */
	@TableField(exist = false)
	private String createTimeStart;
	/**
	 * 查询使用:提交档案时间结束
	 */
	@TableField(exist = false)
	private String createTimeEnd;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@TableField(exist = false)
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@TableField(exist = false)
	private int limitEnd;

	/**
	 * 紧急联系人列表————只取第一个（2025-6-20 10:52:16 倩倩）
	 */
	@TableField(exist = false)
	private List<TGzEmpContactInfo> emergContactList;

	/**
	 * 教育经历列表
	 */
	@TableField(exist = false)
	private List<TGzEmpEducation> eduExpList;

	/**
	 * 家庭成员列表
	 */
	@TableField(exist = false)
	private List<TGzEmpFamily> familyList;

	/**
	 * 工作经历列表
	 */
	@TableField(exist = false)
	private List<TGzEmpWork> workExpList;

	/**
	 * 技能证书列表
	 */
	@TableField(exist = false)
	private List<TGzEmpSkill> skillList;

	/**
	 * 附件列表
	 */
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

	// 员工声明
	@TableField(exist = false)
	private TPreEmpDeclaration tPreEmpDeclaration;


}
