package com.yifu.cloud.plus.v1.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * @Author fxj
 * @Description B端-政策
 * @Date 16:44 2023/1/3
 * @Param
 * @return
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_policy")
@Tag(name = "B端-政策")
public class TPolicy extends Model<TPolicy> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键", name = "id")
     private String id;
     /**
      *
      */
     @NotBlank(message = "标题不能为空")
     @Length(max = 200, message = "标题不能超过200个字符")
     @ExcelAttribute(name = "标题", isNotEmpty = true, errorInfo = "标题不能为空", maxLength = 200)
     @Schema(description = "标题", name = "title")
     private String title;
     /**
      *
      */
     @ExcelAttribute(name = "内容")
     @Schema(description = "内容", name = "content")
     private String content;
     /**
      * 省
      */
     @ExcelAttribute(name = "省")
     @Schema(description = "省", name = "province")
     private Integer province;
     /**
      * 市
      */
     @Length(max = 200, message = "市不能超过200个字符")
     @ExcelAttribute(name = "市", maxLength = 200)
     @Schema(description = "市", name = "city")
     private String city;
     /**
      * 创建人
      */
     @NotBlank(message = "创建人不能为空")
     @Length(max = 32, message = "创建人不能超过32个字符")
     @ExcelAttribute(name = "创建人", isNotEmpty = true, errorInfo = "创建人不能为空", maxLength = 32)
     @Schema(description = "创建人", name = "createUser")
     private String createUser;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间", name = "createTime")
     private LocalDateTime createTime;

     /**
      * 阅读量
      */
     @ExcelAttribute(name = "阅读量")
     @Schema(description = "阅读量", name = "readings")
     private Integer readings;

}
