package com.yifu.cloud.plus.v1.permission.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysUserPermissionService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserPermission;
import com.yifu.cloud.plus.v1.yifu.permission.vo.IdTypeEkpVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysDictVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserDeptVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserPermissionSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;

/**
 * 新权限-用户权限表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysuserpermission")
@Tag(name = "用户权限表管理")
public class SysUserPermissionController {

	private final SysUserPermissionService sysUserPermissionService;

	/**
	 * 简单分页查询
	 *
	 * @param page              分页对象
	 * @param sysUserPermission 新权限-用户权限表
	 * @return
	 */
	@Operation(summary = "简单分页查询",description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysUserPermission>> getSysUserPermissionPage(Page<SysUserPermission> page, SysUserPermissionSearchVo sysUserPermission) {
		return new R<>(sysUserPermissionService.getSysUserPermissionPage(page, sysUserPermission));
	}

	/**
	 * 通过id查询新权限-用户权限表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<SysUserPermission> getById(@PathVariable("id") String id) {
		return R.ok(sysUserPermissionService.getById(id));
	}

	/**
	 * 新增新权限-用户权限表
	 *
	 * @param sysUserPermission 新权限-用户权限表
	 * @return R
	 */
	@Operation(summary = "新增用户权限表",description = "新增用户权限表：hasPermission('permission_sysuserpermission_add')")
	@SysLog("新增用户权限表")
	@PostMapping("/savePermission")
	@PreAuthorize("@pms.hasPermission('permission_sysuserpermission_add')")
	public R save(@RequestBody SysUserPermission sysUserPermission) {
		return sysUserPermissionService.savePermission(sysUserPermission);
	}

	/**
	 * 修改新权限-用户权限表
	 *
	 * @param sysUserPermissionList 用户权限表list
	 * @return R
	 */
	@Operation(summary = "修改用户权限表",description = "修改用户权限表：hasPermission('permission_sysuserpermission_edit')")
	@SysLog("修改用户权限表")
	@PostMapping("/updatePermission")
	@PreAuthorize("@pms.hasPermission('permission_sysuserpermission_edit')")
	public R<Boolean> updateById(@RequestBody List<SysUserPermission> sysUserPermissionList) {
		for (SysUserPermission permission : sysUserPermissionList) {
			sysUserPermissionService.updateById(permission);
		}
		return R.ok();
	}

	/**
	 * 通过id删除新权限-用户权限表
	 *
	 * @param idList
	 * @return R
	 */
	@Operation(summary = "通过id删除用户权限表",description = "通过id删除用户权限表：hasPermission('permission_sysuserpermission_del')")
	@SysLog("通过id删除用户权限表")
	@PostMapping("/deleteByIds")
	@PreAuthorize("@pms.hasPermission('permission_sysuserpermission_del')")
	public R<Boolean> removeById(@RequestBody List<String> idList) {
		return R.ok(sysUserPermissionService.removeBatchByIds(idList));
	}

	/**
	 * 新权限-用户权限表 批量导入
	 *
	 * @author hyc
	 * @date 2023-08-29 14:49:40
	 **/
	@SneakyThrows
	@Operation(summary = "批量新增用户权限表",description = "批量新增用户权限表 hasPermission('permission_sysuserpermission-batch-import')")
	@SysLog("批量新增用户权限表")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('permission_sysuserpermission-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return sysUserPermissionService.importDiy(file.getInputStream());
	}

	/**
	 * 新权限-用户权限表 批量导出
	 *
	 * @author hyc
	 * @date 2023-08-29 14:49:40
	 **/
	@Operation(summary = "导出用户权限表",description = "导出用户权限表")
	@PostMapping("/export")
	@SysLog("批量导出用户权限表")
	public void export(HttpServletResponse response, @RequestBody SysUserPermissionSearchVo searchVo) {
		sysUserPermissionService.listExport(response, searchVo);
	}

	/**
	 * 名称，编码模糊搜索
	 *
	 * @param page              分页对象
	 * @param searchVo 新权限-用户权限表
	 * @return
	 */
	@Operation(summary = "根据名称，编码模糊搜索",description = "根据名称，编码模糊搜索")
	@GetMapping("/customerPage")
	public R<IPage<SysUserDeptVo>> getNameCodePage(Page<SysUserDeptVo> page, SysUserDeptVo searchVo) {
		return new R<>(sysUserPermissionService.getNameCodePage(page,searchVo));
	}

	/**
	 * 根据类型查询字典值
	 *
	 * @param type 字典类型
	 * @return
	 */
	@Operation(summary = "根据类型查询字典值",description = "根据类型查询字典值")
	@PostMapping("/selectDictByType")
	public R<List<SysDictVo>> selectDictByType(@RequestParam String type) {
		return new R<>(sysUserPermissionService.selectDictByType(type));
	}

	/**
	 * 修改项目表--EKP调用接口
	 * @author  hyc
	 * @param jsonStr 项目表
	 * @return R
	 */
	@Operation(summary = "自动同步权限--EKP调用接口", description = "自动同步权限--EKP调用接口")
	@SysLog("自动同步权限--EKP调用接口")
	@PostMapping("/autoCreateAuth")
	public R<String> autoCreateAuth(@RequestBody String  jsonStr) {
		try {
			String json = jsonStr.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
			jsonStr = URLDecoder.decode(json, CommonConstants.UTF8).replace("=", "");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		List<IdTypeEkpVo> list= JSONObject.parseArray(jsonStr, IdTypeEkpVo.class);
		if (list != null && !list.isEmpty()) {
			return sysUserPermissionService.autoCreateAuth(list.get(0));
		}
		return R.failed("自动同步权限错误-无参数");
	}
}
